package cn.com.poc.expose.rest.impl;

import cn.com.poc.agent_application.aggregate.AgentApplicationInfoService;
import cn.com.poc.agent_application.convert.AgentApplicationInfoConvert;
import cn.com.poc.agent_application.convert.BizAgentApplicationDialoguesRecordConvert;
import cn.com.poc.agent_application.convert.BizAgentApplicationPublishConvert;
import cn.com.poc.agent_application.dto.AgentApplicationCreateContinueQuesDto;
import cn.com.poc.agent_application.dto.AgentApplicationInfoSearchDto;
import cn.com.poc.agent_application.dto.BizAgentApplicationDialoguesRecordDto;
import cn.com.poc.agent_application.dto.BizAgentApplicationPublishDto;
import cn.com.poc.agent_application.entity.BizAgentApplicationDialoguesRecordEntity;
import cn.com.poc.agent_application.entity.BizAgentApplicationPublishEntity;
import cn.com.poc.agent_application.query.MemberDialoguesQueryItem;
import cn.com.poc.agent_application.query.PublishAgentApplicationQueryCondition;
import cn.com.poc.agent_application.query.PublishAgentApplicationQueryItem;
import cn.com.poc.agent_application.service.BizAgentApplicationDialoguesRecordService;
import cn.com.poc.agent_application.service.BizAgentApplicationPublishService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.common.utils.UUIDTool;
import cn.com.poc.expose.aggregate.AgentApplicationService;
import cn.com.poc.expose.dto.AgentApplicationDto;
import cn.com.poc.expose.dto.DialoguesContextDto;
import cn.com.poc.expose.dto.SearchAgentApplicationDto;
import cn.com.poc.expose.dto.UserDialoguesDto;
import cn.com.poc.expose.rest.AgentApplicationRest;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class AgentApplicationRestImpl implements AgentApplicationRest {


    @Resource
    private AgentApplicationService agentApplicationService;

    @Resource
    private AgentApplicationInfoService agentApplicationInfoService;

    @Resource
    private BizAgentApplicationPublishService bizAgentApplicationPublishService;

    @Resource
    private BizAgentApplicationDialoguesRecordService bizAgentApplicationDialoguesRecordService;

    @Override
    public String createDialogues(String agentId) {
        return "DIA_" + UUIDTool.getUUID();
    }

    @Override
    public void callAgentApplication(AgentApplicationDto dto, HttpServletResponse httpServletResponse) throws IOException {
        Assert.notNull(dto, "参数不能为空");
        Assert.notBlank(dto.getInput(), "输入不能为空");
        Assert.notNull(dto.getAgentId(), "应用ID不能为空");
        Assert.notNull(dto.getDialogsId(), "对话ID不能为空");
        try {
            agentApplicationService.callAgentApplication(dto.getAgentId(), dto.getDialogsId(), dto.getInput(), httpServletResponse);
        } catch (Exception e) {
            httpServletResponse.setContentType("text/event-stream");
            PrintWriter writer = httpServletResponse.getWriter();
            writer.write("data: {\"code\":-1,\"message\":\"" + e.getMessage() + "\"} \n\n");
            writer.write("data: [DONE]\n\n");
            writer.flush();
        }
    }

    @Override
    public List<SearchAgentApplicationDto> agentApplicationList(AgentApplicationInfoSearchDto dto, PagingInfo pagingInfo) throws Exception {
        PublishAgentApplicationQueryCondition condition = new PublishAgentApplicationQueryCondition();
        if (StringUtils.isNotBlank(dto.getQuery())) {
            condition.setQuery(dto.getQuery());
        }
        List<SearchAgentApplicationDto> result = new ArrayList<>();
        List<PublishAgentApplicationQueryItem> items = bizAgentApplicationPublishService.query(condition, pagingInfo);
        if (CollectionUtils.isNotEmpty(items)) {
            result = items.stream().map(AgentApplicationInfoConvert::itemToSearchDto).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public BizAgentApplicationPublishDto getInfo(String agentId) throws Exception {
        Assert.notBlank(agentId, "应用ID不能为空");
        BizAgentApplicationPublishEntity entity = bizAgentApplicationPublishService.getByAgentId(agentId);
        if (entity == null) {
            throw new BusinessException("应用不存在");
        }
        return BizAgentApplicationPublishConvert.entityToDto(entity);
    }

    @Override
    public void unPublish(String agentId) throws Exception {
        Assert.notBlank(agentId, "应用ID不能为空");
        agentApplicationInfoService.unPublish(agentId);
    }

    @Override
    public List<String> createContinueQuestions(AgentApplicationCreateContinueQuesDto dto) throws Exception {
        cn.com.poc.common.utils.Assert.notNull(dto.getInput(), "input不能为空");
        return agentApplicationService.createContinueQuestions(dto.getInput());
    }

    @Override
    public List<UserDialoguesDto> getUserDialogues() throws Exception {
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        Long userId = userBaseEntity.getUserId();
        List<UserDialoguesDto> result = new ArrayList<>();
        List<MemberDialoguesQueryItem> memberDialoguesQueryItems = bizAgentApplicationDialoguesRecordService.memberDialoguesQuery(userId, null);
        if (CollectionUtils.isNotEmpty(memberDialoguesQueryItems)) {
            result = memberDialoguesQueryItems.stream().map(item -> {
                UserDialoguesDto userDialoguesDto = new UserDialoguesDto();
                userDialoguesDto.setDialogsId(item.getDialogsId());
                userDialoguesDto.setContent(item.getContent());
                return userDialoguesDto;
            }).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public void closeDialogues(String dialogueId) throws Exception {
        Assert.notBlank(dialogueId, "对话ID不能为空");
        BizAgentApplicationDialoguesRecordEntity recordEntity = new BizAgentApplicationDialoguesRecordEntity();
        recordEntity.setDialogsId(dialogueId);
        recordEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAgentApplicationDialoguesRecordEntity> entities = bizAgentApplicationDialoguesRecordService.findByExample(recordEntity, null);
        if (CollectionUtils.isNotEmpty(entities)) {
            for (BizAgentApplicationDialoguesRecordEntity entity : entities) {
                bizAgentApplicationDialoguesRecordService.deletedById(entity.getId());
            }
        }
    }

    @Override
    public void batchCloseDialogues(List<String> dialogueIds) {
        bizAgentApplicationDialoguesRecordService.batchDeleteByDialogueId(dialogueIds);
    }

    @Override
    public List<DialoguesContextDto> getDialogueContext(String dialogueId) throws Exception {
        Assert.notBlank(dialogueId, "对话ID不能为空");
        BizAgentApplicationDialoguesRecordEntity recordEntity = new BizAgentApplicationDialoguesRecordEntity();
        recordEntity.setDialogsId(dialogueId);
        recordEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAgentApplicationDialoguesRecordEntity> entities = bizAgentApplicationDialoguesRecordService.findByExample(recordEntity, null);
        if (CollectionUtils.isNotEmpty(entities)) {
            return entities.stream().map(value -> {
                        DialoguesContextDto dto = new DialoguesContextDto();
                        dto.setRole(value.getRole());
                        dto.setAgentId(value.getAgentId());
                        dto.setContent(value.getContent());
                        dto.setTimestamp(value.getTimestamp());
                        return dto;
                    }
            ).collect(Collectors.toList());
        }
        return null;
    }
}
