package cn.com.poc.knowledge.aggregate;

import cn.com.poc.knowledge.entity.BizKnowledgeDocumentEntity;
import cn.com.poc.thirdparty.resource.demand.ai.entity.knowledge.GetKnowledgeChunkInfoResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.knowledge.SegmentationConfigRequest;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface KnowledgeService {

    /**
     * 上传文档
     *
     * @param documentFiles 文档
     * @return 是否成功
     */
    List<BizKnowledgeDocumentEntity> uploadDocument(MultipartFile[] documentFiles) throws Exception;

    /**
     * 删除文档
     *
     * @param knowledgeInfoId 知识库ID
     * @param kdId            文档ID
     * @return 是否成功
     */
    Boolean delDocument(Integer knowledgeInfoId, Integer kdId);


    /**
     * 重命名
     *
     * @param kdId
     * @param rename
     * @return
     */
    Boolean renameDocument(Integer kdId, String rename) throws Exception;

    /**
     * 启用 / 关闭
     */
    String enableKnowledge(Integer kdId) throws Exception;

    /**
     * 开启训练
     */
    Boolean trainKnowledge(Integer knowledgeInfoId, List<Integer> kdId, SegmentationConfigRequest segmentationConfig) throws Exception;

    /**
     * 获取用户知识库
     */
    List<BizKnowledgeDocumentEntity> searchDocuments(String search, String trainStatus, List<Integer> kdIds, String memberId, PagingInfo pagingInfo);

    /**
     * 获取用户知识库文档
     */
    List<BizKnowledgeDocumentEntity> getListByKdIds(List<Integer> kdIds);


    /**
     * 获取知识库分片
     */
    GetKnowledgeChunkInfoResult getChunkInfo(List<Integer> kdIds, String query, PagingInfo pagingInfo);

    /**
     * 开关知识库分片
     *
     * @param kdId            知识库id
     * @param chunkRelationId 分片关系id
     * @param isOpen          是否开启 Y/N
     */
    void openKnowledgeChunk(Integer kdId, String chunkRelationId, String isOpen);

    /**
     * 删除知识库分片
     *
     * @param kdId            知识库id
     * @param chunkRelationId 分片关系id
     */
    void deleteKnowledgeChunk(Integer kdId, String chunkRelationId);

    /**
     * 更新知识库分片内容
     *
     * @param kdId            知识库id
     * @param chunkRelationId 分片关系id
     * @param content         分片内容
     */
    void updateKnowledgeChunkDoc(Integer kdId, String chunkRelationId, String content);

    /**
     * 新增知识库分片
     *
     * @param kdId      知识库id
     * @param content   分片内容
     * @param chunkSort 分片排序
     */
    void addKnowledgeChunk(Integer kdId, String content, Integer chunkSort);

    /**
     * 获取知识库文档ID列表
     *
     * @param knowledgeInfoIds 知识库信息ID列表
     */
    List<Integer> getKdIdsByKnowledgeInfoIds(String[] knowledgeInfoIds) throws Exception;

}
