package cn.com.poc.knowledge.convert;

import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.knowledge.entity.BizKnowledgeDocumentEntity;
import cn.com.poc.knowledge.model.BizKnowledgeDocumentModel;
import cn.com.poc.thirdparty.resource.demand.ai.entity.knowledge.SegmentationConfigRequest;

public class KnowledgeDocumentConvert {


    public static BizKnowledgeDocumentEntity modelToEntity(BizKnowledgeDocumentModel model) {
        BizKnowledgeDocumentEntity bizKnowledgeDocumentEntity = new BizKnowledgeDocumentEntity();
        bizKnowledgeDocumentEntity.setKdId(model.getKdId());
        bizKnowledgeDocumentEntity.setOwner(model.getOwner());
        bizKnowledgeDocumentEntity.setKnowledgeType(model.getKnowledgeType());
        bizKnowledgeDocumentEntity.setDocumentName(model.getDocumentName());
        bizKnowledgeDocumentEntity.setDocumentUrl(model.getDocumentUrl());
        bizKnowledgeDocumentEntity.setCharCount(model.getCharCount());
        bizKnowledgeDocumentEntity.setUploadTime(model.getUploadTime());
        bizKnowledgeDocumentEntity.setIsEnable(model.getIsEnable());
        if (StringUtils.isNotBlank(model.getSegmentationConfig())) {
            SegmentationConfigRequest segmentationConfigRequest = JsonUtils.deSerialize(model.getSegmentationConfig(), SegmentationConfigRequest.class);
            bizKnowledgeDocumentEntity.setSegmentationConfig(segmentationConfigRequest);
        }
        bizKnowledgeDocumentEntity.setKnowledgeId(model.getKnowledgeId());
        bizKnowledgeDocumentEntity.setDocumentSize(model.getDocumentSize());
        bizKnowledgeDocumentEntity.setTrainStatus(model.getTrainStatus());
        bizKnowledgeDocumentEntity.setIsDeleted(model.getIsDeleted());
        bizKnowledgeDocumentEntity.setCreator(model.getCreator());
        bizKnowledgeDocumentEntity.setCreatedTime(model.getCreatedTime());
        bizKnowledgeDocumentEntity.setModifier(model.getModifier());
        bizKnowledgeDocumentEntity.setModifiedTime(model.getModifiedTime());
        bizKnowledgeDocumentEntity.setSysVersion(model.getSysVersion());
        return bizKnowledgeDocumentEntity;
    }

    public static BizKnowledgeDocumentModel entityToModel(BizKnowledgeDocumentEntity entity) {
        BizKnowledgeDocumentModel bizKnowledgeDocumentModel = new BizKnowledgeDocumentModel();
        bizKnowledgeDocumentModel.setKdId(entity.getKdId());
        bizKnowledgeDocumentModel.setOwner(entity.getOwner());
        bizKnowledgeDocumentModel.setKnowledgeType(entity.getKnowledgeType());
        bizKnowledgeDocumentModel.setDocumentName(entity.getDocumentName());
        bizKnowledgeDocumentModel.setDocumentUrl(entity.getDocumentUrl());
        bizKnowledgeDocumentModel.setCharCount(entity.getCharCount());
        bizKnowledgeDocumentModel.setUploadTime(entity.getUploadTime());
        bizKnowledgeDocumentModel.setDocumentSize(entity.getDocumentSize());
        bizKnowledgeDocumentModel.setIsEnable(entity.getIsEnable());
        bizKnowledgeDocumentModel.setSegmentationConfig(JsonUtils.serialize(entity.getSegmentationConfig()));
        bizKnowledgeDocumentModel.setKnowledgeId(entity.getKnowledgeId());
        bizKnowledgeDocumentModel.setTrainStatus(entity.getTrainStatus());
        bizKnowledgeDocumentModel.setIsDeleted(entity.getIsDeleted());
        bizKnowledgeDocumentModel.setCreator(entity.getCreator());
        bizKnowledgeDocumentModel.setCreatedTime(entity.getCreatedTime());
        bizKnowledgeDocumentModel.setModifier(entity.getModifier());
        bizKnowledgeDocumentModel.setModifiedTime(entity.getModifiedTime());
        bizKnowledgeDocumentModel.setSysVersion(entity.getSysVersion());
        return bizKnowledgeDocumentModel;
    }

}
