package cn.com.poc.knowledge.scheduler;


import cn.com.poc.knowledge.constant.KnowledgeConstant;
import cn.com.poc.knowledge.query.KnowledgeInfosQueryCondition;
import cn.com.poc.knowledge.query.KnowledgeInfosQueryItem;
import cn.com.poc.knowledge.service.BizKnowledgeInfoService;
import cn.com.poc.message.entity.KnowledgeTrainStatusMessage;
import cn.com.poc.message.service.KnowledgeProducerService;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

@Component
public class KnowledgeInfoScheduler {

    @Resource
    private KnowledgeProducerService knowledgeProducerService;

    @Resource
    private BizKnowledgeInfoService bizKnowledgeInfoService;

    @Scheduled(cron = "0 0/1 * * * ?")
    public void knowledgeInfoStatusUpdateScheduler() throws Exception {
        KnowledgeInfosQueryCondition condition = new KnowledgeInfosQueryCondition();
        condition.setTrainStatus(KnowledgeConstant.TrainStatus.TRAINING);

        List<KnowledgeInfosQueryItem> items = bizKnowledgeInfoService.knowledgeInfos(condition, null);
        for (KnowledgeInfosQueryItem item : items) {
            KnowledgeTrainStatusMessage knowledgeTrainStatusMessage = new KnowledgeTrainStatusMessage();
            knowledgeTrainStatusMessage.setKnowledgeInfoId(item.getId());
            knowledgeProducerService.knowledgeInfoStatusCheck(knowledgeTrainStatusMessage);
        }
    }
}
