package cn.com.poc.knowledge.service.impl;

import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.knowledge.convert.MemberKnowledgeRelationConvert;
import cn.com.poc.knowledge.entity.BizMemberKnowledgeRelationEntity;
import cn.com.poc.knowledge.model.BizMemberKnowledgeRelationModel;
import cn.com.poc.knowledge.repository.BizMemberKnowledgeRelationRepository;
import cn.com.poc.knowledge.service.BizMemberKnowledgeRelationService;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class BizMemberKnowledgeRelationServiceImpl extends BaseServiceImpl
        implements BizMemberKnowledgeRelationService {

    @Resource
    private BizMemberKnowledgeRelationRepository repository;

    @Override
    public BizMemberKnowledgeRelationEntity get(Integer id) throws Exception {
        Assert.notNull(id, "id cant be null");
        BizMemberKnowledgeRelationModel model = this.repository.get(id);
        return MemberKnowledgeRelationConvert.modelToEntity(model);
    }

    @Override
    public List<BizMemberKnowledgeRelationEntity> findByExample(BizMemberKnowledgeRelationEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizMemberKnowledgeRelationEntity> result = new ArrayList<>();
        BizMemberKnowledgeRelationModel model = MemberKnowledgeRelationConvert.entityToModel(example);
        List<BizMemberKnowledgeRelationModel> models = this.repository.findByExample(model, pagingInfo);
        if (!CollectionUtils.isEmpty(models)) {
            result = models.stream().map(MemberKnowledgeRelationConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public BizMemberKnowledgeRelationEntity save(BizMemberKnowledgeRelationEntity entity) throws Exception {
        Assert.notNull(entity);
        BizMemberKnowledgeRelationModel model = MemberKnowledgeRelationConvert.entityToModel(entity);
        BizMemberKnowledgeRelationModel saveModel = this.repository.save(model);
        return MemberKnowledgeRelationConvert.modelToEntity(saveModel);
    }

    @Override
    public Boolean deletedByKdId(Integer kdId) {
        Assert.notNull(kdId);

        BizMemberKnowledgeRelationModel bizMemberKnowledgeRelationModel = new BizMemberKnowledgeRelationModel();
        bizMemberKnowledgeRelationModel.setKdId(kdId);
        bizMemberKnowledgeRelationModel.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizMemberKnowledgeRelationModel> models = this.repository.findByExample(bizMemberKnowledgeRelationModel);
        if (CollectionUtils.isEmpty(models)){
            return true;
        }

        if (null != models.get(0)) {
            BizMemberKnowledgeRelationModel model = models.get(0);
            model.setIsDeleted(CommonConstant.IsDeleted.Y);
            this.repository.save(model);
        }
        return true;
    }
}