package cn.com.poc.support.login;


import cn.com.poc.common.constant.Member3ptLoginChannel;
import cn.com.poc.support.login.channel.bl.IBTAuthService;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;


@Component
public class ThirdPlatformAuthServiceBuilder implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    public ThirdPlatformAuthService getService(Member3ptLoginChannel channel) throws Exception {

        if (Member3ptLoginChannel.ibt.equals(channel)) {
            return applicationContext.getBean(IBTAuthService.class);
        }

        throw new BusinessException("第三方授权渠道异常!");
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
