package cn.com.poc.support.login;


import cn.com.poc.common.constant.Member3ptLoginChannel;
import cn.com.poc.support.login.channel.bl.IBTLoginService;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;


@Component
public class ThirdPlatformLoginServiceBuilder implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    public ThirdPlatformLoginService getService(Member3ptLoginChannel channel) throws Exception {

        if (Member3ptLoginChannel.ibt.equals(channel)) {
            return applicationContext.getBean(IBTLoginService.class);
        }
        throw new BusinessException("第三方登录渠道异常");
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
