package cn.com.poc.thirdparty.resource.demand.ai.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

/**
 * @author alex.yao
 * @date 2023/3/9
 **/
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DgtoolsAIDto implements Serializable {

    /**
     * code
     */
    private Integer code;

    /**
     * 错误信息
     */
    private String errorMessage;


    /**
     * 提供商 BAIDU / TENCENT
     */
    private String provider;

    /** 【必填】
     * AI类型  oldman/child/female/man/age/anime
     */
    private String restType;

    //人脸变换
    /**
     * 图片数据
     */
    private String image;

    /**
     * 图片类型
     */
    private String imageType;

    /**
     * 年龄 1-85 [年龄变化必填]
     */
    private Integer age;


    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImageType() {
        return imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public String getProvider() {
        return provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getRestType() {
        return restType;
    }

    public void setRestType(String restType) {
        this.restType = restType;
    }

    public Integer getAge() {
        return age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
