package cn.com.poc.thirdparty.resource.demand.ai.entity.generations;

import cn.com.poc.support.dgTools.request.AbstractRequest;

import java.io.Serializable;

/**
 * @author alex.yao
 * @date 2023/10/9
 **/
public class BaiduGenerationsV2Request extends AbstractRequest<BaiduGetImageV2Result> implements Serializable {

    /**
     * 【必填】 生图的文本描述。仅支持中文、日常标点符号。不支持英文，特殊符号，限制 200 字
     */
    private String prompt;

    /**
     * 【必填】 图片宽度，支持：512x512、640x360、360x640、1024x1024、1280x720、720x1280、2048x2048、2560x1440、1440x2560
     */
    private Integer width;

    /**
     * 【必填】  图片高度，支持：512x512、640x360、360x640、1024x1024、1280x720、720x1280、2048x2048、2560x1440、1440x2560
     */
    private Integer height;

    /**
     * 生成图片数量，默认一张，支持生成 1-8 张
     */
    private Integer imageNum;

    /**
     * 参考图，需 base64 编码，大小不超过 10M，最短边至少 15px，最长边最大 8192px，支持jpg/jpeg/png/bmp 格式。优先级：image > url > pdf_file，当image 字段存在时，url、pdf_file 字段失效
     */
    private String image;

    /**
     * 参考图完整 url，url 长度不超过 1024 字节，url 对应的图片需 base64 编码，大小不超过 10M，最短边至少 15px，最长边最大8192px，支持 jpg/jpeg/png/bmp 格式。优先级：image > url > pdf_file，当image 字段存在时，url 字段失效请注意关闭 URL 防盗链
     */
    private String url;

    /**
     * 参考图 PDF 文件，base64 编码，大小不超过10M，最短边至少 15px，最长边最大 8192px 。优先级：image > url > pdf_file，当image 字段存在时，url、pdf_file 字段失效
     */
    private String pdfFile;

    /**
     * 需要识别的 PDF 文件的对应页码，当pdf_file 参数有效时，识别传入页码的对应页面内容，若不传入，则默认识别第 1 页
     */
    private String pdfFileNum;

    /**
     * 参考图影响因子，支持 1-10 内；数值越大参考图影响越大
     */
    private Integer changeDegree;

    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getImageNum() {
        return imageNum;
    }

    public void setImageNum(Integer imageNum) {
        this.imageNum = imageNum;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPdfFile() {
        return pdfFile;
    }

    public void setPdfFile(String pdfFile) {
        this.pdfFile = pdfFile;
    }

    public String getPdfFileNum() {
        return pdfFileNum;
    }

    public void setPdfFileNum(String pdfFileNum) {
        this.pdfFileNum = pdfFileNum;
    }

    public Integer getChangeDegree() {
        return changeDegree;
    }

    public void setChangeDegree(Integer changeDegree) {
        this.changeDegree = changeDegree;
    }


    @Override
    public String getMethod() throws Exception {
        return null;
    }
}
