package cn.com.poc.thirdparty.resource.demand.auth.service.impl;

import cn.com.poc.thirdparty.resource.demand.auth.entity.BizProjectEntity;
import cn.com.poc.thirdparty.resource.demand.auth.model.BizProjectModel;
import cn.com.poc.thirdparty.resource.demand.auth.repository.BizProjectRepository;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.thirdparty.resource.demand.auth.service.BizProjectService;
import cn.hutool.core.lang.Assert;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class BizProjectServiceImpl extends BaseServiceImpl
        implements BizProjectService {

    @Resource
    private BizProjectRepository repository;

    @Override
    public BizProjectEntity getSecretByAppKey(String appKey){
        Assert.notBlank(appKey);

        BizProjectModel bizProjectModel = new BizProjectModel();
        bizProjectModel.setAppKey(appKey);
        bizProjectModel.setIsDeleted(CommonConstant.IsDeleted.N);

        List<BizProjectModel> models = this.repository.findByExample(bizProjectModel);
        if (CollectionUtils.isEmpty(models)) {
            return null;
        }
        BizProjectEntity bizProjectEntity = new BizProjectEntity();
        bizProjectEntity.setProjectName(models.get(0).getProjectName());
        bizProjectEntity.setAppKey(models.get(0).getAppKey());
        bizProjectEntity.setAppSecret(models.get(0).getAppSecret());


        return bizProjectEntity;
    }
}