package cn.com.poc.thirdparty.resource.demand.member.service.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.thirdparty.resource.demand.member.api.DemandMemberApi;
import cn.com.poc.thirdparty.resource.demand.member.entity.DemandMemberResult;
import cn.com.poc.thirdparty.resource.demand.member.service.DemandAuthService;
import cn.com.poc.thirdparty.resource.demand.member.service.DemandMemberService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2023/6/1
 **/
@Service
public class DemandMemberServiceImpl implements DemandMemberService {


    @Resource
    private DemandMemberApi demandMemberApi;

    @Resource
    private DemandAuthService demandAuthService;

    @Override
    public String createDemandMember() {
        String token = demandAuthService.getToken();
        return demandMemberApi.createDemandMember(token);
    }

    @Override
    public DemandMemberResult searchDemandMember(String demandMemberId) {
        Assert.notBlank(demandMemberId);
        String token = demandAuthService.getToken();
        DemandMemberResult bizProjectMemberResult = demandMemberApi.searchDemandMember(demandMemberId, token);
        if (bizProjectMemberResult != null) {
            return bizProjectMemberResult;
        }
        return null;
    }
}
