package cn.com.poc.user.aggregation.impl;

import cn.com.poc.common.constant.RedisKeyConstant;
import cn.com.poc.common.service.RedisService;
import cn.com.poc.user.dto.MemberPasswordRequestDto;
import cn.com.poc.user.aggregation.MemberInfoService;
import cn.com.poc.user.constants.Member3rdPartyRelationConstants;
import cn.com.poc.user.entity.Member3rdPartyRelationEntity;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.poc.user.service.BizMember3rdPartyRelationService;
import cn.com.poc.user.service.BizMemberInfoService;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @Author：Roger Wu
 * @name：aggregation
 * @Date：2024-07-26 9:40
 */

@Component
public class MemberInfoServiceImpl extends BaseServiceImpl implements MemberInfoService {
    @Resource
    private BizMemberInfoService bizMemberInfoService;
    @Resource
    private BizMember3rdPartyRelationService bizMember3rdPartyRelationService;

    @Resource
    private RedisService redisService;

    /**
     * @param memberPasswordRequestDto
     */
    @Override
    public void configureMemberPassword(MemberPasswordRequestDto memberPasswordRequestDto) throws Exception {

        String authCode = (String) redisService.get(RedisKeyConstant.Code.AUTH_CODE + memberPasswordRequestDto.getAccount());

        if (!memberPasswordRequestDto.getAuthCode().equals(authCode)) {
            throw new BusinessException("请重新验证用户身份");
        }

        MemberInfoEntity memberInfoEntity = bizMemberInfoService.getMemberEntityByAccount(memberPasswordRequestDto.getAccount());
        if (memberInfoEntity == null) {
            throw new BusinessException("找不到该用户");
        }

        Member3rdPartyRelationEntity member3rdPartyRelationEntity = bizMember3rdPartyRelationService.getPwRelationByMemberId(memberInfoEntity.getMemberId());
        if (member3rdPartyRelationEntity == null) {
            member3rdPartyRelationEntity = new Member3rdPartyRelationEntity();
            member3rdPartyRelationEntity.setRelationPlatform(Member3rdPartyRelationConstants.RelationType.PW);
            member3rdPartyRelationEntity.setMemberId(memberInfoEntity.getMemberId());
        }
        member3rdPartyRelationEntity.setRelationKey(memberPasswordRequestDto.getPassword());
        bizMember3rdPartyRelationService.createOrUpdateRelation(member3rdPartyRelationEntity);

        redisService.del(RedisKeyConstant.Code.AUTH_CODE + memberPasswordRequestDto.getAccount());
    }
}
