package cn.com.poc.user.builder;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.user.constants.UserLoginConstants;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 * @Author：Roger Wu
 * @name：LoginChannelBuilder
 * @Date：2024-07-23 18:10
 */
@Component
public class LoginChannelBuilder implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    public LoginChannelService getService(String loginChannel) throws Exception {
        Assert.notBlank(loginChannel, "登录渠道不能为空");
        if (UserLoginConstants.LoginType.MEMBER_PLATFOMR_SMS.equals(loginChannel)) {
            return applicationContext.getBean(SmsLoginChannel.class);
        } else if (UserLoginConstants.LoginType.MEMBER_PLATFOMR_PW.equals(loginChannel)) {
            return applicationContext.getBean(PwLoginChannel.class);
        } else if (UserLoginConstants.LoginType.MEMBER_PLATFOMR_EMAIL.equals(loginChannel)) {
            return applicationContext.getBean(EmailLoginChannel.class);
        }
        throw new BusinessException("第三方授权渠道异常!");
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}