package cn.com.poc.user.builder;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.user.dto.MemberLoginRequestDto;
import cn.com.poc.user.entity.Member3rdPartyRelationEntity;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.poc.user.service.BizMember3rdPartyRelationService;
import cn.com.poc.user.service.BizMemberInfoService;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @Author：Roger Wu
 * @name：SmsLoginChannel
 * @Date：2024-07-23 18:01
 */

@Component
public class PwLoginChannel implements LoginChannelService {

    @Resource
    private BizMemberInfoService bizMemberInfoService;

    @Resource
    private BizMember3rdPartyRelationService bizMember3rdPartyRelationService;


    @Override
    public MemberInfoEntity doLogin(MemberLoginRequestDto memberLoginRequest) throws Exception {

        Assert.notBlank(memberLoginRequest.getPassword(), "通过密码登录，密码不能为空。");

        MemberInfoEntity memberEntityByAccount = bizMemberInfoService.getMemberEntityByAccount(memberLoginRequest.getAccount());

        if (memberEntityByAccount == null) { //用户没有注册过 需要注册
            throw new BusinessException("登录的用户不存在");
        }

        Integer memberId = memberEntityByAccount.getMemberId();
        Member3rdPartyRelationEntity relationByMemberIdEntity = bizMember3rdPartyRelationService.getPwRelationByMemberId(memberId);

        if (relationByMemberIdEntity == null || !memberLoginRequest.getPassword().equals(relationByMemberIdEntity.getRelationKey())) {
            throw new BusinessException("密码错误,请重新输入");
        }
        return memberEntityByAccount;
    }

}
