package cn.com.poc.user.builder;

import cn.com.poc.common.service.JudgeCodeService;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.user.dto.MemberLoginRequestDto;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.poc.user.service.BizMemberInfoService;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.frame.service.FmxParamConfigService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Author：Roger Wu
 * @name：SmsLoginChannel
 * @Date：2024-07-23 18:01
 */

@Service
public class SmsLoginChannel implements LoginChannelService {

    @Resource
    private BizMemberInfoService bizMemberInfoService;
    @Resource
    private JudgeCodeService judgeCodeService;
    @Resource
    private FmxParamConfigService fmxParamConfigService;


    @Override
    public MemberInfoEntity doLogin(MemberLoginRequestDto memberLoginRequest) throws Exception {
        Assert.notBlank(memberLoginRequest.getAccount(), "用户登录，登录账号不能为空");
        Assert.notBlank(memberLoginRequest.getAuthCode(), "用户登录，验证码不能为空");

        //验证验证码
        if (!judgeCodeService.judgeCode(memberLoginRequest.getAccount(), memberLoginRequest.getAuthCode())) {
            throw new BusinessException("验证码有误，请重新输入");
        }

        MemberInfoEntity memberEntityByAccount = bizMemberInfoService.getMemberEntityByAccount(memberLoginRequest.getAccount());
        if (memberEntityByAccount == null) { //用户没有注册过 需要注册
            MemberInfoEntity memberInfoEntity = new MemberInfoEntity();
            memberInfoEntity.setAccount(memberLoginRequest.getAccount());
            memberInfoEntity.setNickName(memberLoginRequest.getAccount());
            String param = fmxParamConfigService.getParam("member.default.avatar");
            if (StringUtils.isNoneBlank(param)) {
                memberInfoEntity.setAvatarUrl(param);
            }
            memberInfoEntity.setMobilePhone(memberLoginRequest.getAccount());
            return bizMemberInfoService.createMemberInfo(memberInfoEntity);
        }

        return memberEntityByAccount;
    }


}
