package cn.com.poc.user.rest;


import cn.com.poc.user.dto.MemberLoginRequestDto;
import cn.com.poc.user.dto.MemberLoginResponseDto;
import cn.com.poc.user.dto.MemberPasswordRequestDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;

@Permission(Access.Safety)
public interface BizMemberInfoRest extends BaseRest {

    /**
     * 用户登录
     */
    @Permission(Access.Anonymous)
    MemberLoginResponseDto doLogin(@RequestBody MemberLoginRequestDto memberLoginRequest) throws Exception;

    /**
     * 用户配置密码
     */
    void configureMemberPassword(@RequestBody MemberPasswordRequestDto memberPasswordRequestDto) throws Exception;

    /**
     * 用户更改密码
     */
    void changeMemberPassword(@RequestBody MemberPasswordRequestDto memberPasswordRequestDto) throws Exception;

    /**
     * 用户忘记密码
     */
    @Permission(Access.Anonymous)
    void forgetMemberPassword(@RequestBody MemberPasswordRequestDto memberPasswordRequestDto) throws Exception;
}