package cn.com.yict.framemax.frame.aggregation.impl;

import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.Assert;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.frame.aggregation.ParamLargerModelConfigService;
import cn.com.yict.framemax.frame.entity.LargeModelConfigEntity;
import cn.com.yict.framemax.frame.entity.TimBreEntity;
import cn.com.yict.framemax.frame.service.LargeModelConfigService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Service
public class ParamLargerModelConfigServiceImpl implements ParamLargerModelConfigService {

    @Resource
    private LargeModelConfigService largeModelConfigService;

    @Override
    public List<String> getLargeModel() throws Exception {
        List<String> resultList = new ArrayList<>();
        LargeModelConfigEntity modelConfigEntity = largeModelConfigService.getByParamCode("largemodel.list");
        String[] dataArray = modelConfigEntity.getParamValue().split(",");
        resultList = Arrays.asList(dataArray);
        return resultList;
    }


    @Override
    public LargeModelConfigEntity save(LargeModelConfigEntity largeModelConfigEntity) throws Exception {
        largeModelConfigEntity.setId(null);
        //1.根据entity获取paramValue
        String paramValue = largeModelConfigEntity.getParamValue();
        List<String> largeModelList = this.getLargeModel();
        boolean isFind = false;
        //寻找有没有这个大模型
        for (String largemodel : largeModelList){
            if(paramValue.equals(largemodel)){
                isFind = true;
            }
        }
        //3.如果没找到，则抛出异常
        if(isFind == false){
            throw new BusinessException("param_value模型不存在");
        }
        //4.根据entity获取音色ID
        Integer timbreId = largeModelConfigEntity.getTimbreId();
        //根据音色ID获取音色code是否存在此音色（数据库里面音色列表中音色的唯一标识）
        LargeModelConfigEntity timbre = largeModelConfigService.getByTimbreId(timbreId);
        if(timbre == null){
            throw new BusinessException("此音色不存在");
        }
        //4.如果都存在，则保存entity
        largeModelConfigEntity.setTimbreName(timbre.getTimbreName());
        return largeModelConfigService.save(largeModelConfigEntity);
    }
    @Override
    public LargeModelConfigEntity update(LargeModelConfigEntity largeModelConfigEntity) throws Exception {
        Assert.notNull(largeModelConfigEntity.getId(), "largeModelConfigId is null");
        LargeModelConfigEntity largeModelConfig = largeModelConfigService.get(largeModelConfigEntity.getId());
        if (largeModelConfig == null || CommonConstant.IsDeleted.Y.equals(largeModelConfig.getIsDeleted())) {
            return null;
        }
        //1.根据entity获取paramValue
        String paramValue = largeModelConfigEntity.getParamValue();
        List<String> largeModelList = this.getLargeModel();
        boolean isFind = false;
        //寻找有没有这个大模型
        for (String largemodel : largeModelList){
            if(paramValue.equals(largemodel)){
                isFind = true;
                break;
            }
        }
        //3.如果没找到，则抛出异常
        if(isFind == false){
            throw new BusinessException("param_value模型不存在");
        }
        //4.根据entity获取音色ID
        Integer timbreId = largeModelConfigEntity.getTimbreId();
        //根据音色ID获取音色code是否存在此音色（数据库里面音色列表中音色的唯一标识）
        LargeModelConfigEntity timbre = largeModelConfigService.getByTimbreId(timbreId);
        if(timbre == null){
            throw new BusinessException("此音色不存在");
        }
        //4.如果都存在，则更新entity
        LargeModelConfigEntity result = largeModelConfigService.update(largeModelConfigEntity);
        return result;
    }

    @Override
    public List<TimBreEntity> getTimBre() throws Exception {
        return largeModelConfigService.getTimBre();
    }


}
