package cn.com.yict.framemax.frame.rest.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.yict.framemax.frame.aggregation.ParamLargerModelConfigService;
import cn.com.yict.framemax.frame.entity.LargeModelConfigEntity;
import cn.com.yict.framemax.frame.entity.TimBreEntity;
import cn.com.yict.framemax.frame.rest.LargeModelConfigRest;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

@Component
public class LargeModelConfigRestImpl implements LargeModelConfigRest {

    @Resource
    ParamLargerModelConfigService paramLargerModelConfigService;

    @Override
    public List<String> getLargeModel() throws Exception {
        return paramLargerModelConfigService.getLargeModel();
    }

    @Override
    public LargeModelConfigEntity saveLargeModelConfig(LargeModelConfigEntity largeModelConfigEntity) throws Exception {
        Assert.notNull(largeModelConfigEntity, "参数不能为空");
        Assert.notNull(largeModelConfigEntity.getParamValue(), "参数不能为空");
        Assert.notNull(largeModelConfigEntity.getTimbreId(), "参数不能为空");
        Assert.notNull(largeModelConfigEntity.getPresencePenalty(), "参数不能为空");
        Assert.notNull(largeModelConfigEntity.getTemperature(), "参数不能为空");
        if(largeModelConfigEntity.getId() == null){
            return paramLargerModelConfigService.save(largeModelConfigEntity);
        }
        return paramLargerModelConfigService.update(largeModelConfigEntity);
    }

    @Override
    public  List<TimBreEntity> getTimBre() throws Exception {
        return paramLargerModelConfigService.getTimBre();
    }

}
