package cn.com.yict.framemax.frame.service.impl;	

import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.Assert;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.frame.convert.LargeModelConfigConvert;
import cn.com.yict.framemax.frame.entity.LargeModelConfigEntity;
import cn.com.yict.framemax.frame.entity.TimBreEntity;
import cn.com.yict.framemax.frame.model.LargeModelConfigModel;
import cn.com.yict.framemax.frame.service.LargeModelConfigService;
import cn.com.yict.framemax.frame.repository.LargeModelConfigRepository;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class LargeModelConfigServiceImpl extends BaseServiceImpl
 			 implements LargeModelConfigService {
   
   @Resource
   private LargeModelConfigRepository repository;


    @Override
    public LargeModelConfigEntity get(Integer id) throws Exception {
        Assert.notNull(id, "largeModelConfigId is null");
        LargeModelConfigModel model = this.repository.get(id);
        if (model == null || model.getIsDeleted().equals(CommonConstant.IsDeleted.Y)) {
            return null;
        }
        return LargeModelConfigConvert.modelToEntity(model);
    }

    @Override
    public List<LargeModelConfigEntity> getAll() throws Exception {
        List<LargeModelConfigModel> configModelList = this.repository.getAll();
        List<LargeModelConfigEntity> resultList = new ArrayList<>();
        for(LargeModelConfigModel model : configModelList){
            resultList.add(LargeModelConfigConvert.modelToEntity(model));
        }
        return resultList;
    }

    @Override
    public LargeModelConfigEntity getByParamCode(String paramCode) throws Exception {
        Assert.notNull(paramCode);
        LargeModelConfigModel model = new LargeModelConfigModel();
        model.setParamCode(paramCode);
        model.setIsDeleted(CommonConstant.IsDeleted.N);
        List<LargeModelConfigModel> models = this.repository.findByExample(model);
        if (CollectionUtils.isNotEmpty(models)) {
            LargeModelConfigEntity entity = new LargeModelConfigEntity();
            BeanUtil.copyProperties(models.get(0), entity);
            return entity;
        }
        return null;
    }

    @Override
    public void deleteById(Integer id) throws Exception {
        Assert.notNull(id, "characterCommunicationId is null");
        //查找characterCommunication
        LargeModelConfigModel largeModelConfigModel = this.repository.get(id);
        if (null == largeModelConfigModel) {
            return;
        }
        largeModelConfigModel.setIsDeleted(CommonConstant.IsDeleted.Y);
        repository.save(largeModelConfigModel);
    }

    @Override
    public LargeModelConfigEntity save(LargeModelConfigEntity entity) throws Exception {
        Assert.notNull(entity, "Cannot save empty objects");
        entity.setId(null);
        LargeModelConfigModel largeModelConfigModel = LargeModelConfigConvert.entityToModel(entity);
        LargeModelConfigModel model = this.repository.save(largeModelConfigModel);
        return LargeModelConfigConvert.modelToEntity(model);
    }

    @Override
    public LargeModelConfigEntity update(LargeModelConfigEntity entity) throws Exception {
        Assert.notNull(entity, "entity is null");
        Assert.notNull(entity.getId(), "entityId is null");
        LargeModelConfigModel largeModelConfigModel = this.repository.get(entity.getId());
        if (largeModelConfigModel == null || CommonConstant.IsDeleted.Y.equals(largeModelConfigModel.getIsDeleted())) {
            return null;
        }
        CopyOptions copyOptions = new CopyOptions().ignoreNullValue();
        BeanUtil.copyProperties(entity, largeModelConfigModel, copyOptions);
        LargeModelConfigModel saveModel = this.repository.save(largeModelConfigModel);
        return LargeModelConfigConvert.modelToEntity(saveModel);
    }

    @Override
    public LargeModelConfigEntity getByTimbreId(Integer timbreId) {
        Assert.notNull(timbreId);
        LargeModelConfigModel model = new LargeModelConfigModel();
        model.setTimbreId(timbreId);
        model.setParamCode("cn.cantonese.timbre.code");
        model.setIsDeleted(CommonConstant.IsDeleted.N);
        List<LargeModelConfigModel> models = this.repository.findByExample(model);
        if (CollectionUtils.isNotEmpty(models)) {
            LargeModelConfigEntity entity = new LargeModelConfigEntity();
            BeanUtil.copyProperties(models.get(0), entity);
            return entity;
        }
        return null;
    }

    @Override
    public List<TimBreEntity> getTimBre() throws Exception {
        List<TimBreEntity> resultList = new ArrayList<>();
        LargeModelConfigModel model = new LargeModelConfigModel();
        model.setParamCode("cn.cantonese.timbre.code");
        model.setIsDeleted(CommonConstant.IsDeleted.N);
        List<LargeModelConfigModel> models = this.repository.findByExample(model);
        for(LargeModelConfigModel largeModelConfigModel : models){
            TimBreEntity timBreEntity = new TimBreEntity();
            timBreEntity.setTimbreId(largeModelConfigModel.getTimbreId());
            timBreEntity.setTimbreName(largeModelConfigModel.getTimbreName());
            resultList.add(timBreEntity);
        }
        return resultList;
    }
}