package cn.com.yict.framemax.frame.service.impl;

import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.core.utils.BeanUtils;
import cn.com.yict.framemax.data.model.DynamicModelClass;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.frame.model.FmxFileModel;
import cn.com.yict.framemax.frame.repository.FmxFileRepository;
import cn.com.yict.framemax.frame.rest.FmxFileRest;
import cn.com.yict.framemax.frame.service.MobileUpdateService;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author Focan Zhong
 * @create 2021/9/6
 */
@Service
public class MobileUpdateServiceImpl extends BaseServiceImpl implements MobileUpdateService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private FmxFileRest fileRest;

    @Resource
    private FmxFileRepository fmxFileRepository;

    /**
     * 保存移动端更新文件
     *
     * @param fileModel
     * @return
     * @throws Exception
     */
    @Override
    public FmxFileModel saveMobilePackage(FmxFileModel fileModel) throws Exception {
        Assert.notNull(fileModel, "file is required");
        if (StringUtils.isEmpty(fileModel.getBizId())) {
            throw new I18nMessageException("framemaxPage/mobileUpdate.appNameEmptyMsg");
        }

        if (StringUtils.isEmpty(fileModel.getFileAttr1())) {
            throw new I18nMessageException("framemaxPage/mobileUpdate.versionEmptyMsg");
        }
        fileModel.setBizType(30);

        logger.info("保存移动端更新文件:[{}]", JSON.toJSONString(fileModel));
        fileModel = fileRest.save(fileModel);
        return fileModel;
    }

    /**
     * 校验移动端是否需要更新
     *
     * @param appName
     * @param versison
     * @param platform
     * @return
     * @throws Exception
     */
    @Override
    public FmxFileModel checkMobilePackage(String appName, String versison, String platform) throws Exception {
        List<DynamicModelClass> file = this.sqlDao.querySQL("select file_id,biz_id,file_name,file_desc,file_attr1,file_attr2,file_attr3,file_attr4 from fmx_file where file_id in (select  max(file_id) from fmx_file  where biz_type='30' and biz_id = ?) and file_attr1 <> ? and file_attr2 IN(?,'wgt')", new Object[]{appName, versison, platform});
        if (file.size() > 0) {
            FmxFileModel fileModel = new FmxFileModel();
            BeanUtils.copy(file.get(0), fileModel);
            return fileModel;
        }
        return null;
    }

    /**
     * 移动端版本记录
     *
     * @param fileModel
     * @return
     * @throws Exception
     */
    @Override
    public List<FmxFileModel> mobilePackageList(FmxFileModel fileModel, PagingInfo pagingInfo) throws Exception {
        Assert.notNull(fileModel, "query is required");

        FmxFileModel modelExample = new FmxFileModel();
        modelExample.setBizType(30);
        modelExample.setBizId(fileModel.getBizId());
        modelExample.setFileName(fileModel.getFileName());
        modelExample.setFileAttr1(fileModel.getFileAttr1());
        modelExample.setFileAttr2(fileModel.getFileAttr2());
        modelExample.setFileAttr3(fileModel.getFileAttr3());
        modelExample.setFileAttr4(fileModel.getFileAttr4());
        return fmxFileRepository.findByExample(modelExample, "file_id DESC", pagingInfo);
    }
}
