package cn.com.poc.knowledge;


import cn.com.poc.common.utils.FileUtils;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.thirdparty.resource.demand.ai.aggregate.DemandKnowledgeService;
import cn.com.poc.thirdparty.resource.demand.ai.common.domain.Message;
import cn.com.poc.thirdparty.resource.demand.ai.common.domain.MultiContent;
import cn.com.poc.thirdparty.resource.demand.ai.entity.knowledge.GetKnowledgeChunkInfoResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelDemandResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelResponse;
import cn.com.poc.thirdparty.service.LLMService;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.hutool.core.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class Demand {

    final private String EVENT_STREAM_PREFIX = "data: ";

    @Resource
    private DemandKnowledgeService demandKnowledgeService;

    @Resource
    private LLMService llmService;

    @Test
    public void test() {

        String str = FileUtils.formatFileSize(1024);
        System.out.println(str);
//        GetKnowledgeChunkInfoResult knowledgeChunkInfos = demandKnowledgeService.getKnowledgeChunkInfos(ListUtil.toList("KnowLedge-1050ef90-7232-487f-ac8b-501002c7b789", "KnowLedge-315f8992-9aa2-4f0b-a06f-9298b1de7504"), new PagingInfo());
//        System.out.println(knowledgeChunkInfos);
    }

    @Test
    public void llmTest() throws Exception {
        List<Message> messageList = new ArrayList<>();
        List<MultiContent> multiContents = new ArrayList<>();
        MultiContent multiContent = new MultiContent();
        multiContents.add(multiContent);
        multiContent.setType("text");
        multiContent.setText("Hello, how are you?");
        Message userMessage = new Message();
        userMessage.setRole("user");
        userMessage.setContent(multiContents);
        messageList.add(userMessage);


        String largeModel = "qwen-max";

        LargeModelResponse largeModelResponse = new LargeModelResponse();
        largeModelResponse.setModel(largeModel);
        largeModelResponse.setMessages(messageList.toArray(new Message[0]));
        largeModelResponse.setTopP(0F);
        largeModelResponse.setStream(true);
        largeModelResponse.setUser("POE");
        BufferedReader bufferedReader = llmService.chatChunk(largeModelResponse);
        String res = "";
        bufferedReader.mark(200);
        while ((res = bufferedReader.readLine()) != null) {
            if (StringUtils.isBlank(res)) {
                continue;
            }
            LargeModelDemandResult result = JsonUtils.deSerialize(res.replaceFirst(EVENT_STREAM_PREFIX, StringUtils.EMPTY), LargeModelDemandResult.class);
            if (!"0".equals(result.getCode())) {
                BusinessException ex = new BusinessException("ʧ");
                throw ex;
            }
            bufferedReader.reset();
            break;
        }

        while ((res = bufferedReader.readLine()) != null) {
            if (StringUtils.isBlank(res)) {
                continue;
            }
            LargeModelDemandResult result = JsonUtils.deSerialize(res.replaceFirst(EVENT_STREAM_PREFIX, StringUtils.EMPTY), LargeModelDemandResult.class);
            if (!"0".equals(result.getCode())) {
                BusinessException ex = new BusinessException("ʧ");
                throw ex;
            }
            System.out.println("result:" + result);
        }

    }

}
