package cn.com.poc.agent_application.convert;

import cn.com.poc.agent_application.dto.AgentApplicationPluginClassificationDto;
import cn.com.poc.agent_application.dto.AgentApplicationPluginDto;
import cn.com.poc.agent_application.model.BizAgentApplicationPluginModel;
import cn.com.poc.agent_application.entity.BizAgentApplicationPluginEntity;
import cn.com.poc.agent_application.query.AgentPluginQueryItem;

import java.util.*;
import java.util.stream.Collectors;

import static cn.com.poc.common.constant.XLangConstant.*;


public class BizAgentApplicationPluginConvert {

    public static BizAgentApplicationPluginEntity modelToEntity(BizAgentApplicationPluginModel model) {
        BizAgentApplicationPluginEntity entity = new BizAgentApplicationPluginEntity();
        entity.setId(model.getId());
        entity.setIcon(model.getIcon());
        entity.setPoints(model.getPoints());
        entity.setClassification(model.getClassification());
        entity.setPluginId(model.getPluginId());
        entity.setDisplayFormat(model.getDisplayFormat());
        entity.setParentZhCnName(model.getParentZhCnName());
        entity.setParentZhTwName(model.getParentZhTwName());
        entity.setParentEnName(model.getParentEnName());
        entity.setZhCnTitle(model.getZhCnTitle());
        entity.setZhTwTitle(model.getZhTwTitle());
        entity.setEnTitle(model.getEnTitle());
        entity.setZhCnDesc(model.getZhCnDesc());
        entity.setZhTwDesc(model.getZhTwDesc());
        entity.setEnDesc(model.getEnDesc());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizAgentApplicationPluginModel entityToModel(BizAgentApplicationPluginEntity entity) {
        BizAgentApplicationPluginModel model = new BizAgentApplicationPluginModel();
        model.setId(entity.getId());
        model.setIcon(entity.getIcon());
        model.setPoints(entity.getPoints());
        model.setDisplayFormat(entity.getDisplayFormat());
        model.setClassification(entity.getClassification());
        model.setPluginId(entity.getPluginId());
        model.setParentZhCnName(entity.getParentZhCnName());
        model.setParentZhTwName(entity.getParentZhTwName());
        model.setParentEnName(entity.getParentEnName());
        model.setZhCnTitle(entity.getZhCnTitle());
        model.setZhTwTitle(entity.getZhTwTitle());
        model.setEnTitle(entity.getEnTitle());
        model.setZhCnDesc(entity.getZhCnDesc());
        model.setZhTwDesc(entity.getZhTwDesc());
        model.setEnDesc(entity.getEnDesc());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }


    public static List<AgentApplicationPluginDto> entitiesToDtos(List<BizAgentApplicationPluginEntity> entities, String lang) {
        List<AgentApplicationPluginDto> result = new ArrayList<>();
        Map<String, List<AgentApplicationPluginDto.PluginInfo>> pluginInfoMap = new HashMap<>();
        Map<String, String> classificationMap = new HashMap<>();
        for (BizAgentApplicationPluginEntity entity : entities) {
            String title = "";
            String desc = "";
            String parentClassificationName = "";
            switch (lang) {
                case ZH_CN:
                    title = entity.getZhCnTitle();
                    desc = entity.getZhCnDesc();
                    parentClassificationName = entity.getParentZhCnName();
                    break;
                case EN:
                    title = entity.getEnTitle();
                    desc = entity.getEnDesc();
                    parentClassificationName = entity.getParentEnName();
                    break;
                case ZH_TW:
                    title = entity.getZhTwTitle();
                    desc = entity.getZhTwDesc();
                    parentClassificationName = entity.getParentZhTwName();
                    break;
            }
            AgentApplicationPluginDto.PluginInfo pluginInfo = new AgentApplicationPluginDto.PluginInfo();
            pluginInfo.setPoints(entity.getPoints());
            pluginInfo.setIcon(entity.getIcon());
            pluginInfo.setTitle(title);
            pluginInfo.setDescription(desc);
            pluginInfo.setPluginId(entity.getPluginId());
            if (!pluginInfoMap.containsKey(parentClassificationName)) {
                pluginInfoMap.put(parentClassificationName, new ArrayList<>());
                classificationMap.put(parentClassificationName, entity.getClassification());
            }
            pluginInfoMap.get(parentClassificationName).add(pluginInfo);
        }

        Set<String> keySet = pluginInfoMap.keySet();
        for (String parentClassificationName : keySet) {
            AgentApplicationPluginDto agentApplicationPluginDto = new AgentApplicationPluginDto();
            agentApplicationPluginDto.setClassificationName(parentClassificationName);
            agentApplicationPluginDto.setPluginInfos(pluginInfoMap.get(parentClassificationName));
            agentApplicationPluginDto.setClassification(classificationMap.get(parentClassificationName));
            result.add(agentApplicationPluginDto);
        }
        return result;
    }

    public static AgentApplicationPluginDto entityToDto(BizAgentApplicationPluginEntity entity, String lang) {
        Map<String, List<AgentApplicationPluginDto.PluginInfo>> pluginInfoMap = new HashMap<>();

        String title = "";
        String desc = "";
        String parentClassificationName = "";
        switch (lang) {
            case ZH_CN:
                title = entity.getZhCnTitle();
                desc = entity.getZhCnDesc();
                parentClassificationName = entity.getParentZhCnName();
                break;
            case EN:
                title = entity.getEnTitle();
                desc = entity.getEnDesc();
                parentClassificationName = entity.getParentEnName();
                break;
            case ZH_TW:
                title = entity.getZhTwTitle();
                desc = entity.getZhTwDesc();
                parentClassificationName = entity.getParentZhTwName();
                break;
        }
        AgentApplicationPluginDto.PluginInfo pluginInfo = new AgentApplicationPluginDto.PluginInfo();
        pluginInfo.setPoints(entity.getPoints());
        pluginInfo.setIcon(entity.getIcon());
        pluginInfo.setTitle(title);
        pluginInfo.setDescription(desc);
        pluginInfo.setPluginId(entity.getPluginId());
        if (!pluginInfoMap.containsKey(parentClassificationName)) {
            pluginInfoMap.put(parentClassificationName, new ArrayList<>());
        }
        pluginInfoMap.get(parentClassificationName).add(pluginInfo);
        AgentApplicationPluginDto agentApplicationPluginDto = new AgentApplicationPluginDto();
        agentApplicationPluginDto.setClassificationName(parentClassificationName);
        agentApplicationPluginDto.setPluginInfos(pluginInfoMap.get(parentClassificationName));
        agentApplicationPluginDto.setClassification(entity.getClassification());
        return agentApplicationPluginDto;
    }

    public static List<AgentApplicationPluginClassificationDto> entitiesToClassificationDtos(List<BizAgentApplicationPluginEntity> entities, String lang) {
        List<AgentApplicationPluginClassificationDto> result = new ArrayList<>();
        Map<String, String> classificationMap = new HashMap<>();
        for (BizAgentApplicationPluginEntity entity : entities) {
            String classificationName = "";
            String classification = entity.getClassification();
            switch (lang) {
                case ZH_CN:
                    classificationName = entity.getParentZhCnName();
                    break;
                case EN:
                    classificationName = entity.getParentEnName();
                    break;
                case ZH_TW:
                    classificationName = entity.getParentZhTwName();
                    break;
            }
            classificationMap.put(classification, classificationName);
        }
        Set<String> keySet = classificationMap.keySet();
        for (String classification : keySet) {
            AgentApplicationPluginClassificationDto classificationDto = new AgentApplicationPluginClassificationDto();
            classificationDto.setClassification(classification);
            classificationDto.setClassificationName(classificationMap.get(classification));
            result.add(classificationDto);
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public static List<AgentApplicationPluginDto> itemsToPluginDtos(List<AgentPluginQueryItem> items, String lang) {
        List<AgentApplicationPluginDto> result = new ArrayList<>();
        Map<String, List<AgentApplicationPluginDto.PluginInfo>> pluginInfoMap = new HashMap<>();
        Map<String, String> classificationMap = new HashMap<>();
        for (AgentPluginQueryItem item : items) {
            String title = "";
            String desc = "";
            String parentClassificationName = "";
            switch (lang) {
                case ZH_CN:
                    title = item.getZhCnTitle();
                    desc = item.getZhCnDesc();
                    parentClassificationName = item.getParentZhCnName();
                    break;
                case EN:
                    title = item.getEnTitle();
                    desc = item.getEnDesc();
                    parentClassificationName = item.getParentEnName();
                    break;
                case ZH_TW:
                    title = item.getZhTwTitle();
                    desc = item.getZhTwDesc();
                    parentClassificationName = item.getParentZhTwName();
                    break;
            }
            AgentApplicationPluginDto.PluginInfo pluginInfo = new AgentApplicationPluginDto.PluginInfo();
            pluginInfo.setPoints(item.getPoints());
            pluginInfo.setIcon(item.getIcon());
            pluginInfo.setTitle(title);
            pluginInfo.setDescription(desc);
            pluginInfo.setPluginId(item.getPluginId());
            if (!pluginInfoMap.containsKey(parentClassificationName)) {
                pluginInfoMap.put(parentClassificationName, new ArrayList<>());
                classificationMap.put(parentClassificationName, item.getClassification());
            }
            pluginInfoMap.get(parentClassificationName).add(pluginInfo);
        }

        Set<String> keySet = pluginInfoMap.keySet();
        for (String parentClassificationName : keySet) {
            AgentApplicationPluginDto agentApplicationPluginDto = new AgentApplicationPluginDto();
            agentApplicationPluginDto.setClassificationName(parentClassificationName);
            agentApplicationPluginDto.setPluginInfos(pluginInfoMap.get(parentClassificationName));
            agentApplicationPluginDto.setClassification(classificationMap.get(parentClassificationName));
            result.add(agentApplicationPluginDto);
        }
        return result;
    }

}