package cn.com.poc.ai_bi.rest.impl;

import cn.com.poc.ai_bi.aggregate.AiBiService;
import cn.com.poc.ai_bi.dto.AiBiDialoguesDto;
import cn.com.poc.ai_bi.rest.AiBiRest;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2025/6/20
 */

@Component
public class AiBiRestImpl implements AiBiRest {

    @Resource
    private AiBiService aiBiService;

    @Override
    public void call(AiBiDialoguesDto dto) throws Exception {
        Assert.notNull(dto);
        Assert.notBlank(dto.getDialoguesId(), "对话id不能为空");
        Assert.notBlank(dto.getInput(), "输入内容不能为空");

        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (ObjectUtils.isEmpty(userBaseEntity)) {
            throw new BusinessException("用户未登录");
        }
        aiBiService.call(dto.getDialoguesId(),
                dto.getInput(),
                dto.getFileUrl(),
                dto.getKnowledgeIds(),
                dto.getDatabaseIds(),
                userBaseEntity.getUserId());
    }
}
