package cn.com.poc.ai_dialogues.aggregate;

import cn.com.poc.ai_dialogues.constant.AiDialoguesTypeEnum;
import cn.com.poc.ai_dialogues.dto.AiDialoguesRecordDto;
import cn.com.poc.expose.dto.DialoguesContextDto;

import java.util.List;

/**
 * @author alex.yao
 * @date 2025/6/19
 */
public interface AiDialoguesService {

    /**
     * 创建对话
     *
     * @param type   对话类型
     * @param userId 用户ID
     * @return 对话ID
     */
    String create(AiDialoguesTypeEnum type, Long userId) throws Exception;

    /**
     * 创建对话
     *
     * @param fileUrl 文件地址
     * @param type    对话类型
     * @param userId  用户ID
     * @return 对话ID
     */
    String create(AiDialoguesTypeEnum type, String fileUrl, Long userId) throws Exception;


    /**
     * 获取对话详情
     *
     * @param dialoguesId 对话ID
     * @param userId      用户ID
     */
    AiDialoguesRecordDto dialoguesDetail(String dialoguesId, Long userId) throws Exception;


    /**
     * 获取对话列表
     *
     * @param type   对话类型
     * @param userId 用户ID
     */
    List<AiDialoguesRecordDto> getList(AiDialoguesTypeEnum type, Long userId) throws Exception;


    /**
     * 批量删除对话列表
     *
     * @param dialoguesIds 对话ID列表
     * @param userId       用户ID
     */
    void batchDelete(List<String> dialoguesIds, Long userId) throws Exception;


    /**
     * 获取对话上下文
     *
     * @param dialogueId 对话ID
     */
    List<DialoguesContextDto> getDialogueContext(String dialogueId);


    /**
     * 问题联想
     *
     * @param dialogueId 对话ID - 非必填
     * @param question   问题文本
     * @return 联想结果列表
     */
    List<String> questionAssociation(String dialogueId, String question);

}
