package cn.com.poc.ai_dialogues.constant;

/**
 * @author alex.yao
 * @date 2025/6/19
 */
public enum AiDialoguesTypeEnum {

    PORTAL("portal", "门户页对话"),

    LONG_TEXT_DOCUMENT("long_text_document", "长文本文档"),

    AI_WRITING("ai_writing", "AI写作"),

    AI_BI("ai_bi", "智能问数"),

    ;

    private final String type;

    private final String desc;

    AiDialoguesTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }


    public static AiDialoguesTypeEnum getByType(String type) {
        for (AiDialoguesTypeEnum aiDialoguesTypeEnum : AiDialoguesTypeEnum.values()) {
            if (aiDialoguesTypeEnum.getType().equals(type)) {
                return aiDialoguesTypeEnum;
            }
        }
        return null;
    }
}
