package cn.com.poc.common.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Random;

/**
 * @author Dyce.Zhou
 * @create 2018-12-14 16:55
 **/
public class NumberUtils {

    private static String[] chinese = {"零", "一", "二", "三", "四", "五", "六", "七", "八", "九"};
    private static String[] replace = {"|〇", "|壹", "|贰", "|叁", "|肆", "|伍", "", "", "", ""};
    private static Hashtable<Character, Long> digits = new Hashtable();
    private static String[] commonDigit = {"", "十", "百", "千"};
    private static String[] twiceDigit = {"万", "亿", "兆"};

    static {
        digits.put('十', 10L);
        digits.put('百', 100L);
        digits.put('千', 1000L);
        digits.put('万', 10000L);
        digits.put('亿', 100000000L);
        digits.put('兆', 10000000000000000L);
    }

    /**
     * 格式化金额
     *
     * @param amount
     * @return
     */
    public static String formatAmount(Integer amount) {
        if (amount == null) {
            return "0.00";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        return decimalFormat.format(new BigDecimal(amount).divide(new BigDecimal(100)));
    }

    /**
     * 将阿拉伯数字转换为中文
     *
     * @param number
     * @return
     */
    public static String formatToChinese(Integer number) {
        //千以上位计数器
        int[] twiceDigitCounter = new int[twiceDigit.length];
        String numStr = simpleFormat(number);
        //{三,零,零,零,零,五}
        char[] nums = numStr.toCharArray();
        StringBuffer addDigit = new StringBuffer(nums.length * 2);
        int index = 0;
        boolean appendZero = false;
        //倒序装载十百千，若遇千位以上，特殊处理(getDigitByCounter)
        for (int i = nums.length - 1; i >= 0; i--) {
            if (appendZero && lastIsNum(addDigit)) {
                addDigit.append("零");
                appendZero = false;
            }
            if (index == commonDigit.length) {
                String current = getDigitByCounter(twiceDigitCounter);
                String last = getLast(addDigit);
                if (indexOf(last) < indexOf(current)) {
                    addDigit.delete(addDigit.length() - 1, addDigit.length());
                }
                addDigit.append(current);
                index = 0;
            }
            if (nums[i] == '零') {
                appendZero = true;
            } else {
                if (index != commonDigit.length) {
                    addDigit.append(commonDigit[index]);
                }
                addDigit.append(nums[i]);
            }
            index++;

        }
        return addDigit.reverse().toString();
    }

    /**
     * 简单转换为 二零零一七三五一八
     *
     * @param number
     * @return
     */
    private static String simpleFormat(long number) {
        String numStr = String.valueOf(number);
        for (int i = 0, len = chinese.length; i < len; i++) {
            numStr = numStr.replaceAll(Integer.toString(i), chinese[i]);
        }
        return numStr;
    }

    /**
     * 万出现两次则为亿，亿出现两次则为兆
     * 因此，千位以上从万计数，
     * 若万没出现过，则为万。
     * 若万出现过，则置万为没出现过，进位到亿
     *
     * @return
     */
    private static String getDigitByCounter(int[] twiceDigitCounter) {
        for (int i = 0, len = twiceDigit.length; i < len; i++) {
            if (twiceDigitCounter[i] == 0) {
                twiceDigitCounter[i] = 1;
                return twiceDigit[i];
            } else if (twiceDigitCounter[i] == 1) {
                twiceDigitCounter[i] = 0;
            }
        }
        twiceDigitCounter[0] = 1;
        return twiceDigit[0];
    }

    /**
     * 得到最后一位
     *
     * @param addDigit
     * @return
     */
    private static String getLast(StringBuffer addDigit) {
        if (addDigit.length() == 0) {
            return null;
        }
        return addDigit.substring(addDigit.length() - 1);
    }

    /**
     * 万亿兆。。。的位置
     *
     * @param digit
     * @return
     */
    private static int indexOf(String digit) {
        for (int i = 0, len = twiceDigit.length; i < len; i++) {
            if (twiceDigit[i].equals(digit)) {
                return i;
            }
        }
        return twiceDigit.length;
    }

    /**
     * 最后一位是否为非零数字(不可为万/亿等计位符)
     *
     * @param addDigit
     * @return
     */
    private static boolean lastIsNum(StringBuffer addDigit) {
        String last = getLast(addDigit);
        for (int i = 1, len = chinese.length; i < len; i++) {
            if (chinese[i].equals(last)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 将byte转为16进制
     *
     * @param bytes
     * @return
     */
    public static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; i++) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                //1得到一位的进行补0操作
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    /**
     * 获取随机数
     * @return
     */
    public static String genRandomNum() {
        int maxNum = 8;
        int i;
        int count = 0;
        char[] str = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K',
                'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',
                'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        StringBuffer pwd = new StringBuffer("");
        Random r = new Random();
        while (count < 8) {
            i = Math.abs(r.nextInt(maxNum));
            if (i >= 0 && i < str.length) {
                pwd.append(str[i]);
                count++;
            }
        }
        return pwd.toString();
    }

    static Integer DEFAULT_ZERO = new Integer(0);

    public static Integer defaultZeroIfNull(Integer value) {
        return value == null ? DEFAULT_ZERO : value;
    }

    public static Double defaultZeroIfNull(Double value) {
        return value == null ? DEFAULT_ZERO : value;
    }
}
