package cn.com.poc.equity.convert;	

import cn.com.poc.equity.model.BizMemberEquityModel;
import cn.com.poc.equity.entity.BizMemberEquityEntity;
import cn.com.poc.equity.dto.BizMemberEquityDto;


public class BizMemberEquityConvert {

    public static BizMemberEquityEntity modelToEntity(BizMemberEquityModel model){
        BizMemberEquityEntity entity = new BizMemberEquityEntity();
        entity.setId(model.getId());
        entity.setMemberId(model.getMemberId());
        entity.setEquityLevel(model.getEquityLevel());
        entity.setExpiredDate(model.getExpiredDate());
        entity.setEquityConfig(model.getEquityConfig());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizMemberEquityModel entityToModel(BizMemberEquityEntity entity){
        BizMemberEquityModel model = new BizMemberEquityModel();
        model.setId(entity.getId());
        model.setMemberId(entity.getMemberId());
        model.setEquityLevel(entity.getEquityLevel());
        model.setExpiredDate(entity.getExpiredDate());
        model.setEquityConfig(entity.getEquityConfig());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }
    
    public static BizMemberEquityDto entityToDto(BizMemberEquityEntity entity){
        BizMemberEquityDto dto = new BizMemberEquityDto();
        dto.setId(entity.getId());
        dto.setMemberId(entity.getMemberId());
        dto.setEquityLevel(entity.getEquityLevel());
        dto.setExpiredDate(entity.getExpiredDate());
        dto.setEquityConfig(entity.getEquityConfig());
        dto.setIsDeleted(entity.getIsDeleted());
        dto.setCreator(entity.getCreator());
        dto.setCreatedTime(entity.getCreatedTime());
        dto.setModifier(entity.getModifier());
        dto.setModifiedTime(entity.getModifiedTime());
        dto.setSysVersion(entity.getSysVersion());
        return dto;
    }

    public static BizMemberEquityEntity dtoToEntity(BizMemberEquityDto dto){
        BizMemberEquityEntity entity = new BizMemberEquityEntity();
        entity.setId(dto.getId());
        entity.setMemberId(dto.getMemberId());
        entity.setEquityLevel(dto.getEquityLevel());
        entity.setExpiredDate(dto.getExpiredDate());
        entity.setEquityConfig(dto.getEquityConfig());
        entity.setIsDeleted(dto.getIsDeleted());
        entity.setCreator(dto.getCreator());
        entity.setCreatedTime(dto.getCreatedTime());
        entity.setModifier(dto.getModifier());
        entity.setModifiedTime(dto.getModifiedTime());
        entity.setSysVersion(dto.getSysVersion());
        return entity;
    }
}