package cn.com.poc.formreport.strategy;


import cn.com.poc.formreport.FormReportRequest;

import java.util.List;

/**
 * @author Helen
 * @date 2021/12/21 16:54
 */
public interface FormReportStrategy {

    /**
     * 获取报表导出的数据
     * @return
     */
    public List<Object> getFormReportData(FormReportRequest reportRequest) throws Exception;

    /**
     * 获取excel表对应的实体
     */
    public Class getExcelEntityClass();

    /**
     * 获取报表文件名
     */
    public String getExcelName(FormReportRequest reportRequest) throws Exception;

    /**
     * 动态表头
     * @return
     */
    List<List<String>> dynamicHead(FormReportRequest reportRequest) throws Exception;

    /**
     * 动态数据
     * @return
     */
    List<List<String>> dynamicData(FormReportRequest reportRequest) throws Exception;

    /**
     * 动态数据
     * @return
     */
    List<List<Object>> dynamicDataObject(FormReportRequest reportRequest) throws Exception;
}
