package cn.com.poc.knowledge.convert;

import cn.com.poc.knowledge.model.BizKnowledgeDatabaseModel;
import cn.com.poc.knowledge.entity.BizKnowledgeDatabaseEntity;
import cn.com.poc.knowledge.dto.BizKnowledgeDatabaseDto;
import cn.com.poc.knowledge.query.KnowledgeDatabaseQueryInfoQueryItem;


public class BizKnowledgeDatabaseConvert {

    public static BizKnowledgeDatabaseEntity modelToEntity(BizKnowledgeDatabaseModel model) {
        BizKnowledgeDatabaseEntity entity = new BizKnowledgeDatabaseEntity();
        entity.setId(model.getId());
        entity.setMemberId(model.getMemberId());
        entity.setTitle(model.getTitle());
        entity.setDbDesc(model.getDbDesc());
        entity.setDbType(model.getDbType());
        entity.setDbHost(model.getDbHost());
        entity.setDbPort(model.getDbPort());
        entity.setDbName(model.getDbName());
        entity.setDbUsername(model.getDbUsername());
        entity.setDbPassword(model.getDbPassword());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizKnowledgeDatabaseModel entityToModel(BizKnowledgeDatabaseEntity entity) {
        BizKnowledgeDatabaseModel model = new BizKnowledgeDatabaseModel();
        model.setId(entity.getId());
        model.setMemberId(entity.getMemberId());
        model.setTitle(entity.getTitle());
        model.setDbDesc(entity.getDbDesc());
        model.setDbType(entity.getDbType());
        model.setDbHost(entity.getDbHost());
        model.setDbPort(entity.getDbPort());
        model.setDbName(entity.getDbName());
        model.setDbUsername(entity.getDbUsername());
        model.setDbPassword(entity.getDbPassword());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }

    public static BizKnowledgeDatabaseDto entityToDto(BizKnowledgeDatabaseEntity entity) {
        BizKnowledgeDatabaseDto dto = new BizKnowledgeDatabaseDto();
        dto.setId(entity.getId());
        dto.setMemberId(entity.getMemberId());
        dto.setTitle(entity.getTitle());
        dto.setDesc(entity.getDbDesc());
        dto.setDbType(entity.getDbType());
        dto.setDbHost(entity.getDbHost());
        dto.setDbPort(entity.getDbPort());
        dto.setDbName(entity.getDbName());
        dto.setDbUsername(entity.getDbUsername());
        dto.setDbPassword(entity.getDbPassword());
        dto.setModifiedTime(entity.getModifiedTime());
        return dto;
    }

    public static BizKnowledgeDatabaseEntity dtoToEntity(BizKnowledgeDatabaseDto dto) {
        BizKnowledgeDatabaseEntity entity = new BizKnowledgeDatabaseEntity();
        entity.setId(dto.getId());
        entity.setMemberId(dto.getMemberId());
        entity.setTitle(dto.getTitle());
        entity.setDbDesc(dto.getDesc());
        entity.setDbType(dto.getDbType());
        entity.setDbHost(dto.getDbHost());
        entity.setDbPort(dto.getDbPort());
        entity.setDbName(dto.getDbName());
        entity.setDbUsername(dto.getDbUsername());
        entity.setDbPassword(dto.getDbPassword());
        return entity;
    }

    public static BizKnowledgeDatabaseDto itemToDto(KnowledgeDatabaseQueryInfoQueryItem item) {
        BizKnowledgeDatabaseDto bizKnowledgeDatabaseDto = new BizKnowledgeDatabaseDto();
        bizKnowledgeDatabaseDto.setId(item.getId());
        bizKnowledgeDatabaseDto.setMemberId(item.getMemberId());
        bizKnowledgeDatabaseDto.setTitle(item.getTitle());
        bizKnowledgeDatabaseDto.setDesc(item.getDbDesc());
        bizKnowledgeDatabaseDto.setDbType(item.getDbType());
        bizKnowledgeDatabaseDto.setDbHost(item.getDbHost());
        bizKnowledgeDatabaseDto.setDbPort(item.getDbPort());
        bizKnowledgeDatabaseDto.setDbName(item.getDbName());
        bizKnowledgeDatabaseDto.setDbUsername(item.getDbUsername());
        bizKnowledgeDatabaseDto.setDbPassword(item.getDbPassword());
        bizKnowledgeDatabaseDto.setModifiedTime(item.getModifiedTime());
        return bizKnowledgeDatabaseDto;
    }
}