package cn.com.poc.long_document.rest;

import cn.com.poc.long_document.dto.LongTextDialoguesCallDto;
import cn.com.poc.long_document.dto.LongTextExampleDto;
import cn.com.poc.long_document.dto.LongTextSummaryDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 长文档对话接口
 *
 * @author alex.yao
 * @date 2025/6/3
 */
@Permission(Access.Safety)
public interface LongTextDialoguesRest extends BaseRest {


    /**
     * 核心观点提取、总结摘要
     */
    LongTextSummaryDto summary(@RequestParam String dialoguesId) throws Exception;

    /**
     * 对话调用
     *
     * @param dto
     * @throws Exception
     */
    void call(@RequestBody LongTextDialoguesCallDto dto) throws Exception;


    /**
     * 示例
     *
     * @return
     * @throws Exception
     */
    List<LongTextExampleDto> example() throws Exception;

}
