package cn.com.poc.portal.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.portal.service.BizPortalDialoguesService;
import cn.com.poc.portal.model.BizPortalDialoguesModel;
import cn.com.poc.portal.entity.BizPortalDialoguesEntity;
import cn.com.poc.portal.convert.BizPortalDialoguesConvert;
import cn.com.poc.portal.repository.BizPortalDialoguesRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizPortalDialoguesServiceImpl extends BaseServiceImpl
 			 implements BizPortalDialoguesService {
   
   @Resource
   private BizPortalDialoguesRepository repository;
    			 
   public BizPortalDialoguesEntity get(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizPortalDialoguesModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        if ("Y".equals(model.getIsDeleted())){
            return null;
        }
        return BizPortalDialoguesConvert.modelToEntity(model);
   }

       
   public List<BizPortalDialoguesEntity> findByExample(BizPortalDialoguesEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizPortalDialoguesEntity> result = new  ArrayList<BizPortalDialoguesEntity>();
        BizPortalDialoguesModel model = new BizPortalDialoguesModel();
        if (example != null){
            model = BizPortalDialoguesConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizPortalDialoguesModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizPortalDialoguesConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizPortalDialoguesEntity save(BizPortalDialoguesEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizPortalDialoguesModel model = BizPortalDialoguesConvert.entityToModel(entity);
        BizPortalDialoguesModel saveModel =  this.repository.save(model);
        return BizPortalDialoguesConvert.modelToEntity(saveModel);
    }

    public BizPortalDialoguesEntity update(BizPortalDialoguesEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizPortalDialoguesModel model = this.repository.get(entity.getId());

       if (entity.getDialoguesId() != null){
        model.setDialoguesId(entity.getDialoguesId());
       }
       if (entity.getUserId() != null){
        model.setUserId(entity.getUserId());
       }
       if (entity.getTitle() != null){
        model.setTitle(entity.getTitle());
       }
       if (entity.getIsDeleted() != null){
        model.setIsDeleted(entity.getIsDeleted());
       }
       if (entity.getCreator() != null){
        model.setCreator(entity.getCreator());
       }
       if (entity.getCreatedTime() != null){
        model.setCreatedTime(entity.getCreatedTime());
       }
       if (entity.getModifier() != null){
        model.setModifier(entity.getModifier());
       }
       if (entity.getModifiedTime() != null){
        model.setModifiedTime(entity.getModifiedTime());
       }
       if (entity.getSysVersion() != null){
        model.setSysVersion(entity.getSysVersion());
       }
        BizPortalDialoguesModel saveModel =  this.repository.save(model);
        return BizPortalDialoguesConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizPortalDialoguesModel model =  this.repository.get(id);
        if (model != null){
            if ("N".equals(model.getIsDeleted())){
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
       }
   }
    
}