package cn.com.poc.thirdparty.resource.demand.pay.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for biz_order_detail
 */
@Entity
@Table(name = "biz_order_detail")
@DynamicInsert
@DynamicUpdate
public class BizOrderDetailModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * order_detail_id
     */
    private Integer orderDetailId;

    @Column(name = "order_detail_id", length = 10)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Integer getOrderDetailId() {
        return this.orderDetailId;
    }

    public void setOrderDetailId(Integer orderDetailId) {
        this.orderDetailId = orderDetailId;
        super.addValidField("orderDetailId");
    }


    /**
     * order_id
     * 关联biz_order的主键
     */
    private Integer orderId;

    @Column(name = "order_id", length = 10)
    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
        super.addValidField("orderId");
    }


    /**
     * relation_type
     * 关联类型
     */
    private String relationType;

    @Column(name = "relation_type", length = 15)
    public String getRelationType() {
        return this.relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
        super.addValidField("relationType");
    }


    /**
     * relation_id
     * 关联id
     */
    private String relationId;

    @Column(name = "relation_id", length = 50)
    public String getRelationId() {
        return this.relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
        super.addValidField("relationId");
    }


    /**
     * relation_name
     * 关联名
     */
    private String relationName;

    @Column(name = "relation_name", length = 255)
    public String getRelationName() {
        return this.relationName;
    }

    public void setRelationName(String relationName) {
        this.relationName = relationName;
        super.addValidField("relationName");
    }


    /**
     * is_deleted
     * 是否删除 Y 是  N 否
     */
    private String isDeleted;

    @Column(name = "is_deleted", length = 1)
    public String getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(String isDeleted) {
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }


    /**
     * CREATOR
     * 创建人
     */
    private String creator;

    @Column(name = "CREATOR", length = 11)
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
        super.addValidField("creator");
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    @Column(name = "CREATED_TIME", length = 19)
    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }


    /**
     * MODIFIER
     * 修改人
     */
    private String modifier;

    @Column(name = "MODIFIER", length = 11)
    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
        super.addValidField("modifier");
    }


    /**
     * MODIFIED_TIME
     * 修改时间
     */
    private java.util.Date modifiedTime;

    @Column(name = "MODIFIED_TIME", length = 19)
    public java.util.Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(java.util.Date modifiedTime) {
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }


    /**
     * SYS_VERSION
     * 乐观锁,版本号
     */
    private Integer sysVersion;

    @Column(name = "SYS_VERSION", length = 10)
    @Version
    public Integer getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(Integer sysVersion) {
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }


}