package cn.com.poc.thirdparty.service.impl;

import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.thirdparty.resource.demand.ai.aggregate.AIDialogueService;
import cn.com.poc.thirdparty.resource.demand.ai.entity.csvchain.CSVChainResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.csvchain.CSVChainResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dbchain.DBChainResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dbchain.DBChainResult;
import cn.com.poc.thirdparty.service.ChainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2025/4/27
 */
@Service
public class ChainServiceImpl implements ChainService {

    private Logger logger = LoggerFactory.getLogger(ChainServiceImpl.class);

    @Resource
    private AIDialogueService aiDialogueService;

    @Override
    public DBChainResult dbChain(DBChainResponse response) {
        logger.info("dbChain response : {}", response);
        DBChainResult dbChainResult = aiDialogueService.dbChain(response);
        if (dbChainResult == null || dbChainResult.getStatus().equals("error")) {
            logger.error("dbChain result error : {} , response:{}", dbChainResult, response);
            return null;
        }
        if (StringUtils.isBlank(dbChainResult.getSqlResult())) {
            logger.warn("dbChain result sqlResult is blank : {} , response:{}", dbChainResult, response);
            return null;
        }
        return dbChainResult;
    }

    @Override
    public CSVChainResult csvChain(CSVChainResponse response) {
        logger.info("csvChain response : {}", response);
        CSVChainResult csvChainResult = aiDialogueService.csvChain(response);
        if (csvChainResult == null || csvChainResult.getStatus().equals("error")) {
            logger.error("csvChain result error : {} , response:{}", csvChainResult, response);
            return null;
        }
        if (StringUtils.isBlank(csvChainResult.getResult())) {
            logger.warn("csvChain result sqlResult is blank : {} , response:{}", csvChainResult, response);
            return null;
        }

        return csvChainResult;
    }
}
