package cn.com.poc.user.service.impl;

import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.common.utils.UUIDTool;
import cn.com.poc.user.convert.MemberInfoConvert;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.poc.user.query.CheckMemberInfoQueryCondition;
import cn.com.poc.user.query.CheckMemberInfoQueryItem;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.user.service.BizMemberInfoService;
import cn.com.poc.user.model.BizMemberInfoModel;
import cn.com.poc.user.repository.BizMemberInfoRepository;
import cn.com.yict.framemax.frame.service.FmxParamConfigService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import javax.annotation.Resource;

@Service
public class BizMemberInfoServiceImpl extends BaseServiceImpl
        implements BizMemberInfoService {

    @Resource
    private BizMemberInfoRepository repository;

    @Resource
    private FmxParamConfigService fmxParamConfigService;


    @Override
    public MemberInfoEntity getById(Integer memberId) throws Exception {
        BizMemberInfoModel bizMemberInfoModel = this.repository.get(memberId);
        if (bizMemberInfoModel == null) {
            return null;
        }
        return MemberInfoConvert.convertModel2Entity(bizMemberInfoModel);
    }

    @Override
    public MemberInfoEntity getMemberEntityByAccount(String account) throws Exception {
        Assert.notBlank(account);
        BizMemberInfoModel example = new BizMemberInfoModel();
        example.setIsDeleted(CommonConstant.IsDeleted.N);
        example.setAccount(account);
        List<BizMemberInfoModel> bizMemberInfoModelList = repository.findByExample(example);
        if (CollectionUtils.isEmpty(bizMemberInfoModelList)) {
            return null;
        }
        BizMemberInfoModel bizMemberInfoModel = bizMemberInfoModelList.get(0);
        return MemberInfoConvert.convertModel2Entity(bizMemberInfoModel);
    }

    /**
     * @param memberInfoEntity
     * @return
     */
    @Override
    public MemberInfoEntity createMemberInfo(MemberInfoEntity memberInfoEntity) {
        BizMemberInfoModel model = new BizMemberInfoModel();
        model.setAccount(memberInfoEntity.getAccount());
        model.setNickName(memberInfoEntity.getNickName());
        model.setMobilePhone(memberInfoEntity.getMobilePhone());
        model.setAvatarUrl(memberInfoEntity.getAvatarUrl());
        model.setEmail(memberInfoEntity.getEmail());

        if (checkVaildAccountExist(memberInfoEntity.getAccount())) {
            throw new I18nMessageException("exception/account.has.already");
        }

        if (StringUtils.isBlank(memberInfoEntity.getAvatarUrl())) {
            String param = fmxParamConfigService.getParam("member.default.avatar");
            if (StringUtils.isNoneBlank(param)) {
                model.setAvatarUrl(param);
            }
        }

        if (StringUtils.isBlank(memberInfoEntity.getShareCode())) {
            model.setShareCode(UUIDTool.getUUID());
        }
        return MemberInfoConvert.convertModel2Entity(repository.save(model));
    }

    @Override
    public MemberInfoEntity updateMemberInfo(MemberInfoEntity memberInfoEntity) {
        Assert.notNull(memberInfoEntity.getMemberId());
        BizMemberInfoModel bizMemberInfoModel = repository.get(memberInfoEntity.getMemberId());
        if (StringUtils.isNotBlank(memberInfoEntity.getNickName())) {
            if (memberInfoEntity.getNickName().length() > 20) {
                throw new I18nMessageException("exception/nickName.max.len");
            }
            bizMemberInfoModel.setNickName(memberInfoEntity.getNickName());
        }
        if (StringUtils.isNotBlank(memberInfoEntity.getAvatarUrl())) {
            bizMemberInfoModel.setAvatarUrl(memberInfoEntity.getAvatarUrl());
        }
        if (StringUtils.isNotBlank(memberInfoEntity.getMobilePhone())) {
            bizMemberInfoModel.setMobilePhone(memberInfoEntity.getMobilePhone());
        }
        if (StringUtils.isNotBlank(memberInfoEntity.getEmail())) {
            bizMemberInfoModel.setEmail(memberInfoEntity.getEmail());
        }
        if (StringUtils.isNotBlank(memberInfoEntity.getRemark())) {
            if (memberInfoEntity.getRemark().length() > 200) {
                throw new I18nMessageException("exception/remark.max.len");
            }
            bizMemberInfoModel.setRemark(memberInfoEntity.getRemark());
        }
        BizMemberInfoModel saveModel = this.repository.save(bizMemberInfoModel);
        return MemberInfoConvert.convertModel2Entity(saveModel);
    }

    @Override
    public List<CheckMemberInfoQueryItem> checkMemberInfoIsExist(CheckMemberInfoQueryCondition condition) {
        return this.sqlDao.query(condition, CheckMemberInfoQueryItem.class);
    }

    private boolean checkVaildAccountExist(String account) {
        BizMemberInfoModel example = new BizMemberInfoModel();
        example.setAccount(account);
        example.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizMemberInfoModel> bizMemberInfoModelList = repository.findByExample(example);
        if (CollectionUtils.isEmpty(bizMemberInfoModelList)) {
            return false;
        }
        return true;
    }
}