package cn.com.poc.writing.rest.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.poc.writing.aggregate.AiWritingService;
import cn.com.poc.writing.dto.AiWritingDto;
import cn.com.poc.writing.rest.AiWritingRest;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2025/6/20
 */
@Component
public class AiWritingRestImpl implements AiWritingRest {

    @Resource
    private AiWritingService aiWritingService;

    @Override
    public void call(AiWritingDto aiWritingDto) throws Exception {
        Assert.notNull(aiWritingDto, "aiWritingDto is null");
        Assert.notBlank(aiWritingDto.getInput(), "input is null");
        Assert.notBlank(aiWritingDto.getDialoguesId(), "dialogues id is null");

        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }
        aiWritingService.call(aiWritingDto.getDialoguesId(), aiWritingDto.getFileUrl(),
                aiWritingDto.getInput(), aiWritingDto.getKnowledgeIds(), userBaseEntity.getUserId());

    }
}
