package cn.com.poc.agent_application.service.impl;

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.agent_application.service.BizAgentApplicationLargeModelListService;
import cn.com.poc.agent_application.model.BizAgentApplicationLargeModelListModel;
import cn.com.poc.agent_application.entity.BizAgentApplicationLargeModelListEntity;
import cn.com.poc.agent_application.convert.BizAgentApplicationLargeModelListConvert;
import cn.com.poc.agent_application.repository.BizAgentApplicationLargeModelListRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizAgentApplicationLargeModelListServiceImpl extends BaseServiceImpl
        implements BizAgentApplicationLargeModelListService {

    @Resource
    private BizAgentApplicationLargeModelListRepository repository;

    @Override
    public BizAgentApplicationLargeModelListEntity findByModelNickName(String modelNickName) {
        Assert.notNull(modelNickName);

        BizAgentApplicationLargeModelListModel bizAgentApplicationLargeModelListModel = new BizAgentApplicationLargeModelListModel();
        bizAgentApplicationLargeModelListModel.setModelNickName(modelNickName);
        List<BizAgentApplicationLargeModelListModel> models = this.repository.findByExample(bizAgentApplicationLargeModelListModel);
        if (CollectionUtils.isNotEmpty(models)) {
            return BizAgentApplicationLargeModelListConvert.modelToEntity(models.get(0));
        }
        return null;
    }

    public BizAgentApplicationLargeModelListEntity get(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizAgentApplicationLargeModelListModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        return BizAgentApplicationLargeModelListConvert.modelToEntity(model);
    }


    public List<BizAgentApplicationLargeModelListEntity> findByExample(BizAgentApplicationLargeModelListEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizAgentApplicationLargeModelListEntity> result = new ArrayList<BizAgentApplicationLargeModelListEntity>();
        BizAgentApplicationLargeModelListModel model = new BizAgentApplicationLargeModelListModel();
        if (example != null) {
            model = BizAgentApplicationLargeModelListConvert.entityToModel(example);
        }
        List<BizAgentApplicationLargeModelListModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAgentApplicationLargeModelListConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAgentApplicationLargeModelListEntity save(BizAgentApplicationLargeModelListEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        BizAgentApplicationLargeModelListModel model = BizAgentApplicationLargeModelListConvert.entityToModel(entity);
        BizAgentApplicationLargeModelListModel saveModel = this.repository.save(model);
        return BizAgentApplicationLargeModelListConvert.modelToEntity(saveModel);
    }

    public BizAgentApplicationLargeModelListEntity update(BizAgentApplicationLargeModelListEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizAgentApplicationLargeModelListModel model = this.repository.get(entity.getId());

        if (entity.getModelName() != null) {
            model.setModelName(entity.getModelName());
        }
        if (entity.getOwner() != null) {
            model.setOwner(entity.getOwner());
        }
        BizAgentApplicationLargeModelListModel saveModel = this.repository.save(model);
        return BizAgentApplicationLargeModelListConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizAgentApplicationLargeModelListModel model = this.repository.get(id);
        if (model != null) {
        }
    }

}