package cn.com.poc.common.utils;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CutImageUtil {

    /**
     * 切割图片
     *
     * @param index 竖直方向等分切割数
     * @return List<String> base64编码数组
     */
    public static List<byte[]> cutImageToByte(byte[] data, int index) throws Exception {
        List<byte[]> list = new ArrayList<byte[]>();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        BufferedImage source = ImageIO.read(in);
        int width = source.getWidth(); // 图片宽度
        int height = source.getHeight(); // 图片高度
        if (index > 1) {
            int cHeight = height / index;// 切片高度
            BufferedImage image = null;
            for (int i = 0; i < index; i++) {
                // x坐标,y坐标,宽度,高度
                int ch = i * cHeight;
                image = source.getSubimage(0, ch, width, cHeight);
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                ImageIO.write(image, "PNG", outStream);
                list.add(outStream.toByteArray());
                outStream.close();
            }
        }
        return list;
    }

    /**
     * 切割图片
     *
     * @param data  源文件数据
     * @param index 水平方向等分切割数
     * @return List<byte [ ]> 二进制
     */
    public static List<byte[]> cutImageToByteHorizontal(byte[] data, int index) throws Exception {
        List<byte[]> list = new ArrayList<byte[]>();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        BufferedImage source = ImageIO.read(in);
        int width = source.getWidth(); // 图片宽度
        int height = source.getHeight(); // 图片高度

        if (index > 1) {
            int cWidth = width / index;// 切片高度
            BufferedImage image = null;
            for (int i = 0; i < index; i++) {
                // x坐标,y坐标,宽度,高度
                int ch = i * cWidth;
                image = source.getSubimage(ch, 0, cWidth, height);
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                ImageIO.write(image, "PNG", outStream);
                list.add(outStream.toByteArray());
                outStream.close();
            }
        }
        return list;
    }

    /**
     * 图片按高度切割
     *
     * @param data      图片数据
     * @param cutHeight 裁切高度
     * @return List<byte [ ]> 截取后图片数据
     * @throws IOException IO异常
     */
    public static List<byte[]> cuteHighImage(byte[] data, int cutHeight) throws IOException {
        List<byte[]> list = new ArrayList<byte[]>();

        //读取图片数据
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        BufferedImage source = ImageIO.read(in);
        int width = source.getWidth(); // 图片宽度
        int height = source.getHeight(); // 图片高度

        //高度裁剪上半张
        BufferedImage image = null;
        image = source.getSubimage(0, 0, width, cutHeight);
        ByteArrayOutputStream topHalfOutputStream = new ByteArrayOutputStream();
        ImageIO.write(image, "PNG", topHalfOutputStream);
        list.add(topHalfOutputStream.toByteArray());

        //高度裁剪下半张
        image = source.getSubimage(0, cutHeight, width, height - cutHeight);
        ByteArrayOutputStream bottomHalfOutputStream = new ByteArrayOutputStream();
        ImageIO.write(image, "PNG", bottomHalfOutputStream);
        list.add(bottomHalfOutputStream.toByteArray());

        //关闭
        topHalfOutputStream.close();
        bottomHalfOutputStream.close();
        return list;
    }

    /**
     * 图片按宽度切割
     *
     * @param data     图片数据
     * @param cutWidth 裁切宽度
     * @return List<byte [ ]> 截取后图片数据
     * @throws IOException IO异常
     */
    public static List<byte[]> cuteHorizontal(byte[] data, int cutWidth) throws IOException {
        List<byte[]> result = new ArrayList<>();

        //读取图片数据
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        BufferedImage source = ImageIO.read(in);
        int width = source.getWidth(); // 图片宽度
        int height = source.getHeight(); // 图片高度

        //水平裁剪左半张
        BufferedImage image = null;
        image = source.getSubimage(0, 0, cutWidth, height);
        ByteArrayOutputStream leftHalfOutputStream = new ByteArrayOutputStream();
        ImageIO.write(image, "PNG", leftHalfOutputStream);
        result.add(leftHalfOutputStream.toByteArray());

        //水平裁剪右半张
        image = source.getSubimage(cutWidth, 0, width - cutWidth, height);
        ByteArrayOutputStream rightHalfOutputStream = new ByteArrayOutputStream();
        ImageIO.write(image, "PNG", rightHalfOutputStream);
        result.add(rightHalfOutputStream.toByteArray());

        //关闭
        leftHalfOutputStream.close();
        rightHalfOutputStream.close();
        return result;
    }
}
