package cn.com.poc.common.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * <p>
 * Title: 基础类
 * </p>
 * <p>
 * Description: 日期转换
 * </p>
 * <p>
 * Copyright: Copyright (c) 2002
 * </p>
 * <p>
 * Company:
 * </p>
 *
 * @version 1.0
 */
public class DateUtils {

    public static class DateFormats {

        public static final String ISO_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
        public static final String ISO_DATETIME_TIME_ZONE_FORMAT = "yyyy-MM-dd HH:mm:ssZ";
        public static final String ISO_DATETIME_NO_SECOND_FORMAT = "yyyy-MM-dd HH:mm";

        public static final String CN_DATETIME_FORMAT = "yyyy年MM月dd日HH时mm分ss秒";
        public static final String CN_SHORT_DATETIME_FORMAT = "yyyy年MM月dd日HH时mm分";

        public static final String ISO_DATETIME_MILLISECOND_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        public static final String ISO_DATETIME_T_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
        public static final String ISO_DATETIME_T_TIME_ZONE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
        public static final String ISO_DATETIME_MILLISECOND_TIME_ZONE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

        public static final String ISO_DATETIME_NO_T_FORMAT = "yyyy-MM-dd HH:mm:ss";
        public static final String ISO_DATETIME_TIME_ZONE_NO_T_FORMAT = "yyyy-MM-dd HH:mm:ssZ";
        public static final String ISO_DATETIME_NO_SECOND_NO_T_FORMAT = "yyyy-MM-dd HH:mm";

        public static final String ISO_DATETIME_MILLISECOND_NO_T_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
        public static final String ISO_DATETIME_MILLISECOND_TIME_ZONE_NO_T_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSZ";

        public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
        public static final String CN_DATE_FORMAT = "yyyy年MM月dd日";
        public static final String ISO_DATE_TIME_ZONE_FORMAT = "yyyy-MM-ddZ";

        public static final String ISO_TIME_FORMAT = "'T'HH:mm:ss";
        public static final String ISO_TIME_MILLISECOND_FORMAT = "'T'HH:mm:ss.SSS";

        public static final String ISO_TIME_TIME_ZONE_FORMAT = "'T'HH:mm:ssZZ";
        public static final String ISO_TIME_MILLISECOND_TIME_ZONE_FORMAT = "'T'HH:mm:ss.SSSZ";

        public static final String ISO_TIME_NO_T_FORMAT = "HH:mm:ss";
        public static final String ISO_TIME_MILLISECOND_NO_T_FORMAT = "HH:mm:ss.SSS";
        public static final String CN_TIME_FORMAT = "HH时mm分ss秒";

        public static final String ISO_TIME_NO_T_TIME_ZONE_FORMAT = "HH:mm:ssZZ";
        public static final String ISO_TIME_MILLISECOND_NO_T_TIME_ZONE_FORMAT = "HH:mm:ss.SSSZ";

        public static final String SMTP_DATETIME_FORMAT = "EEE, dd MMM yyyy HH:mm:ss Z";
        public static final String SMTP_DATETIME_MILLISECOND_FORMAT = "EEE, dd MMM yyyy HH:mm:ss.SSS Z";

        public static final String ISO_MONTH_FORMAT = "yyyy-MM";
        public static final String CN_MONTH_FORMAT = "yyyy年MM月";

        public static final String US_DATETIME_TIME_ZONE_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    }

    public static org.apache.commons.lang3.time.DateUtils commonDateUtils;
    /**
     * Date Style
     */
    public static final String DATESTYLE = "yyyyMMddHHmmss";

    /**
     * Date Style for Extention
     */
    public static final String DATESTYLE_EX = "yyyy-MM-dd_HH-mm-ss";

    /**
     * Date Style for Extention
     */
    public static final String DATESTYLE_ = "yyyy-MM-dd";

    /**
     * Date Style for Year & Month
     */
    public static final String DATESTYLE_YEAR_MONTH = "yyyyMM";

    /**
     * Date Style for Short
     */
    public static final String DATESTYLE_SHORT = "yyyyMMdd";

    /**
     * Date Style for Extention
     */
    public static final String DATESTYLE_SHORT_EX = "yyyy/MM/dd";

    /**
     * Date Style for Year & Month Extention
     */
    public static final String DATESTYLE_YEAR_MONTH_EX = "yyyy/MM";

    /**
     * Date Style for detail
     */
    public static final String DATESTYLE_DETAIL = "yyyyMMddHHmmssSSS";

    public static final String yyyy_MM_dd_HH_mm_ss = "yyyy-MM-dd HH:mm:ss";
    public static final String yyyy_MM_dd = "yyyy-MM-dd";
    public static final String yyyyMMdd = "yyyyMMdd";

    public static final String HHmm = "HH:mm";

    /**
     * 日期转化为字符串
     *
     * @param date 时间
     * @return yyyy-MM-dd HH:mm:ss 格式化的时间字符串
     */
    public static String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        return formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    /**
     * 日期转化为字符串
     *
     * @param date 时间
     * @return yyyy-MM-dd 格式化的时间字符串
     */
    public static String dateToStringShort(Date date) {
        if (date == null) {
            return "";
        }
        return formatDate(date, "yyyy-MM-dd");
    }

    /**
     * 计算两个日期差（毫秒）
     *
     * @param date1 时间1
     * @param date2 时间2
     * @return 相差毫秒数
     */
    public static long diffTwoDate(Date date1, Date date2) {
        long l1 = date1.getTime();
        long l2 = date2.getTime();
        return (l1 - l2);
    }

    /**
     * 计算两个日期差（天）
     *
     * @param date1 时间1
     * @param date2 时间2
     * @return 相差天数
     */
    public static int diffTwoDateDay(Date date1, Date date2) {
        long l1 = date1.getTime();
        long l2 = date2.getTime();
        int diff = Integer.parseInt("" + (l1 - l2) / 3600 / 24 / 1000);
        return diff;
    }


    /**
     * 计算两个日期差（天）
     *
     * @param date1 时间1
     * @param date2 时间2
     * @return 相差天数
     */
    public static int diffTwoDateNaturalDay(Date date1, Date date2) {
        return diffTwoDateDay(getDayStartTime(date1), getDayStartTime(date2));
    }

    /**
     * @return 相差时间 格式： XX天XX小时XX分钟
     */
    public static String diffTwoDateDHM(Date start, Date end) {
        if (start == null && end == null) {
            return "0天0小时0分";
        }

        if (start == null || end == null) {
            return null;
        }
        int diffMinutes = Integer.parseInt((end.getTime() - start.getTime()) / 1000 / 60 + "");
        int days = Integer.parseInt(diffMinutes / 60 / 24 + "");
        int hours = Integer.parseInt((diffMinutes - 60 * 24 * days) / 60 + "");
        int minutes = diffMinutes - 60 * 24 * days - 60 * hours;

        return days + "天" + hours + "小时" + minutes + "分";
    }

    /**
     * 对日期进行格式化
     *
     * @param date 日期
     * @param sf   日期格式
     * @return 字符串
     */
    public static String formatDate(Date date, String sf) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat = new SimpleDateFormat(sf);
        return dateformat.format(date);
    }

    /**
     * 取得当前系统日期
     *
     * @return yyyy-MM-dd
     */
    public static String getCurrDate() {
        Date dateTime = new Date();
        return formatDate(dateTime, "yyyy-MM-dd");
    }

    // 取系统时间时一定要用这个方法，否则日期可能不动
    public static Date getCurrDateTime() {
        return new Date(System.currentTimeMillis());
    }

    /**
     * 取得当前系统时间
     *
     * @return yyyy-MM-dd HH:mm:ss
     */
    public static String getCurrTime() {
        Date dateTime = new Date();
        return formatDate(dateTime, "yyyy-MM-dd HH:mm:ss");
    }

    /**
     * 10位时间转为8时间
     *
     * @param str
     * @return
     */
    public static String getDate10to8(String str) {
        String y = str.substring(0, 4);
        String m = str.substring(5, 7);
        String d = str.substring(8, 10);
        return y + m + d;
    }

    /**
     * 8位时间转为10时间
     *
     * @param str
     * @return
     */
    public static String getDate8to10(String str) {
        String y = str.substring(0, 4);
        String m = str.substring(4, 6);
        String d = str.substring(6, 8);
        return y + "-" + m + "-" + d;
    }

    /**
     * 取得日期的天份
     *
     * @param date 日期
     * @return dd 天字符串
     */
    public static String getDay(Date date) {
        return formatDate(date, "dd");
    }

    /**
     * 取得日期的小时
     *
     * @param date 日期
     * @return hh 小时字符串
     */
    public static String getHour(Date date) {
        return formatDate(date, "HH");
    }

    /**
     * 取得日期的分钟
     *
     * @param date 时间
     * @return mm 分钟字符串
     */
    public static String getMinute(Date date) {
        return formatDate(date, "mm");
    }

    /**
     * 取得日期的月份
     *
     * @param date 日期
     * @return mm 月份字符串
     */
    public static String getMonth(Date date) {
        return formatDate(date, "MM");
    }

    public static int getMonth(Date start, Date end) {
        if (start.after(end)) {
            Date t = start;
            start = end;
            end = t;
        }
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        Calendar temp = Calendar.getInstance();
        temp.setTime(end);
        temp.add(Calendar.DATE, 1);

        int year = endCalendar.get(Calendar.YEAR) - startCalendar.get(Calendar.YEAR);
        int month = endCalendar.get(Calendar.MONTH) - startCalendar.get(Calendar.MONTH);

        if ((startCalendar.get(Calendar.DATE) == 1) && (temp.get(Calendar.DATE) == 1)) {
            return year * 12 + month + 1;
        } else if ((startCalendar.get(Calendar.DATE) != 1) && (temp.get(Calendar.DATE) == 1)) {
            return year * 12 + month;
        } else if ((startCalendar.get(Calendar.DATE) == 1) && (temp.get(Calendar.DATE) != 1)) {
            return year * 12 + month;
        } else {
            return (year * 12 + month - 1) < 0 ? 0 : (year * 12 + month);
        }
    }

    /**
     * 取得时间的秒
     *
     * @param date 时间
     * @return ss 秒字符串
     */
    public static String getSecond(Date date) {
        return formatDate(date, "ss");
    }

    /**
     * 根据年、月取得月末的日期
     *
     * @param year 年
     * @return time 返回日期格式"yyyy-mm-dd"
     * @parm month 月
     */
    public static String getTime(String year, String month) {
        String time = "";
        int len = 31;
        int iYear = Integer.parseInt(year);
        int iMonth = Integer.parseInt(month);
        if (iMonth == 4 || iMonth == 6 || iMonth == 9 || iMonth == 11) {
            len = 30;
        }
        if (iMonth == 2) {
            len = 28;
            if ((iYear % 4 == 0 && iYear % 100 == 0 && iYear % 400 == 0) || (iYear % 4 == 0 && iYear % 100 != 0)) {
                len = 29;
            }
        }
        time = year + "-" + month + "-" + String.valueOf(len);
        return time;
    }

    /**
     * 取得日期的年份
     *
     * @param date 日期
     * @return yyyy 年份字符串
     */
    public static String getYear(Date date) {
        return formatDate(date, "yyyy");
    }

    /**
     * 字符串转换为日期
     *
     * @param dateString yyyy-MM-dd HH:mm:ss
     * @return 日期
     */
    public static Date stringToDate(String dateString) {
        if (dateString == null || dateString.trim().length() == 0) {
            return null;
        }
        String datestr = dateString.trim();

        String sf = "yyyy-MM-dd HH:mm:ss";
        Date dt = stringToDate(datestr, sf);
        if (dt == null) {
            dt = stringToDate(datestr, "yyyy-MM-dd");
        }
        if (dt == null) {
            dt = stringToDate(datestr, "yyyyMMdd");
        }
        return dt;
    }

    /**
     * 字符串转换为日期
     *
     * @param dateString 日期格式字符串
     * @param sf         日期格式化定义
     * @return 转换后的日期
     */
    public static Date stringToDate(String dateString, String sf) {
        ParsePosition pos = new ParsePosition(0);
        SimpleDateFormat sdf = new SimpleDateFormat(sf);
        Date dt = sdf.parse(dateString, pos);
        return dt;
    }

    /**
     * 字符串转换为日期
     *
     * @param dateString yyyy-MM-dd
     * @return 日期
     */
    public static Date stringToDateShort(String dateString) {
        String sf = "yyyy-MM-dd";
        Date dt = stringToDate(dateString, sf);
        return dt;
    }

    /**
     * 取得日以上粒度起始时间
     *
     * @param granularity   粒度
     * @param statisticDate 结束时间
     * @return 起始时间
     */
    public String getBeginDate(String granularity, String statisticDate) {
        String beginDate = "";
        Date date = stringToDateShort(statisticDate);
        Date beginDateTemp = null;
        if (granularity.equals("1")) {// 日
            beginDateTemp = date;
        }
        if (granularity.equals("2")) {// 周
            beginDateTemp = getWeekBegin(date);
        }
        if (granularity.equals("3")) {// 旬
            beginDateTemp = getPeriodBegin(date);
        } else if (granularity.equals("4")) {// 月
            beginDateTemp = getMonthBegin(date);
        } else if (granularity.equals("5")) {// 季
            beginDateTemp = getSeasonBegin(date);
        } else if (granularity.equals("6")) {// 半年
            beginDateTemp = getHalfYearBegin(date);
        } else if (granularity.equals("7")) {// 年
            beginDateTemp = getYearBegin(date);
        }
        beginDate = dateToStringShort(beginDateTemp);
        return beginDate;
    }

    /**
     * @param currentTime 计算日期
     * @param type        偏移的类别
     * @param iQuantity   偏移数量
     * @return 偏移后的时间串
     */
    public String getDateChangeALL(String currentTime, String type, int iQuantity) {
        Date curr = null;
        String newtype = "";
        if (currentTime.length() == 10) {
            curr = stringToDateShort(currentTime);
        }
        if (currentTime.length() > 10) {
            curr = stringToDate(currentTime);
        }

        // 日
        if (type.equals("1")) {
            newtype = "d";
        }
        // 周，按照7天计算
        else if (type.equals("2")) {
            iQuantity = iQuantity * 7;
            newtype = "d";
        }
        // 旬，按照10天计算
        else if (type.equals("3")) {
            iQuantity = iQuantity * 10;
            newtype = "d";
        }
        // 月
        else if (type.equals("4")) {
            iQuantity = iQuantity;
            newtype = "m";
        }
        // 旬，按照3个月计算
        else if (type.equals("5")) {
            iQuantity = iQuantity * 3;
            newtype = "m";
        }
        // 半年，按照六个月计算
        else if (type.equals("6")) {
            iQuantity = iQuantity * 6;
            newtype = "m";
        }
        // 年
        else if (type.equals("7")) {
            newtype = "y";
        } else {
            iQuantity = iQuantity;
            newtype = "d";
        }

        Date change = getDateChangeTime(curr, newtype, iQuantity);

        return dateToStringShort(change);
    }

    /**
     * @param currentTime 计算的日期
     * @param type        偏移的类别
     * @param iQuantity   偏移数量
     * @return 偏移后的时间
     */
    public Date getDateChangeTime(Date currentTime, String type, int iQuantity) {
        int year = Integer.parseInt(formatDate(currentTime, "yyyy"));
        int month = Integer.parseInt(formatDate(currentTime, "MM"));
        // 月份修正
        month = month - 1;
        int day = Integer.parseInt(formatDate(currentTime, "dd"));
        int hour = Integer.parseInt(formatDate(currentTime, "HH"));
        int mi = Integer.parseInt(formatDate(currentTime, "mm"));
        int ss = Integer.parseInt(formatDate(currentTime, "ss"));
        GregorianCalendar gc = new GregorianCalendar(year, month, day, hour, mi, ss);
        // 月份修正
        // gc.add(GregorianCalendar.MONTH, -1);
        if (type.equalsIgnoreCase("y")) {
            gc.add(GregorianCalendar.YEAR, iQuantity);
        } else if (type.equalsIgnoreCase("m")) {
            gc.add(GregorianCalendar.MONTH, iQuantity);
        } else if (type.equalsIgnoreCase("d")) {
            gc.add(GregorianCalendar.DATE, iQuantity);
        } else if (type.equalsIgnoreCase("h")) {
            gc.add(GregorianCalendar.HOUR, iQuantity);
        } else if (type.equalsIgnoreCase("mi")) {
            gc.add(GregorianCalendar.MINUTE, iQuantity);
        } else if (type.equalsIgnoreCase("s")) {
            gc.add(GregorianCalendar.SECOND, iQuantity);
        }
        return gc.getTime();
    }

    /**
     * 将世界时间格式字符串转化成日期类型数据
     * @param dateString yyyy-MM-dd'T'hh:mm:ss.SSS
     * @return Date
     */
    public static Date getDateByWorldTimeFormatString(String dateString){
        SimpleDateFormat simpleDateFormatWorld = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = simpleDateFormatWorld.parse(dateString);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        String returnDateString = simpleDateFormat.format(date);
        return stringToDate(returnDateString);
    }

    /**
     * @param currentTime 计算的日期
     * @param type        偏移的类别
     * @param iQuantity   偏移数量
     * @return 偏移后的时间串
     */
    public String getDateChangeTime(String currentTime, String type, int iQuantity) {
        Date curr = stringToDate(currentTime);
        curr = getDateChangeTime(curr, type, iQuantity);
        return dateToString(curr);
    }

    /**
     * 取得日以上粒度起始时间
     *
     * @param granularity   粒度
     * @param statisticDate 结束时间
     * @return 起始时间
     */
    public String getEndDate(String granularity, String statisticDate) {
        String beginDate = "";
        Date date = stringToDateShort(statisticDate);
        Date beginDateTemp = null;

        if (granularity.equals("1")) {// 日
            beginDateTemp = date;
        }
        if (granularity.equals("2")) {// 周
            beginDateTemp = getWeekEnd(date);
        }
        if (granularity.equals("3")) {// 旬
            beginDateTemp = getPeriodEnd(date);
        } else if (granularity.equals("4")) {// 月
            beginDateTemp = getMonthEnd(date);
        } else if (granularity.equals("5")) {// 季
            beginDateTemp = getSeasonEnd(date);
        } else if (granularity.equals("6")) {// 半年
            beginDateTemp = getHalfYearEnd(date);
        } else if (granularity.equals("7")) {// 年
            beginDateTemp = getYearEnd(date);
        }

        beginDate = dateToStringShort(beginDateTemp);
        return beginDate;
    }

    /**
     * 取半年初
     *
     * @param date
     * @return
     */
    public Date getHalfYearBegin(Date date) {
        int year = Integer.parseInt(formatDate(date, "yyyy"));
        int month = Integer.parseInt(formatDate(date, "MM"));
        String newDateStr = formatDate(date, "yyyy") + "-";
        if (month <= 6) {
            newDateStr += "01-01";
        } else {
            newDateStr += "07-01";
        }
        return stringToDateShort(newDateStr);
    }

    /**
     * 取半年末
     *
     * @param date
     * @return
     */
    public Date getHalfYearEnd(Date date) {
        int year = Integer.parseInt(formatDate(date, "yyyy"));
        int month = Integer.parseInt(formatDate(date, "MM"));
        String newDateStr = formatDate(date, "yyyy") + "-";
        if (month <= 6) {
            newDateStr += "06-30";
        } else {
            newDateStr += "12-31";
        }
        return stringToDateShort(newDateStr);
    }

    /**
     * 取月初
     *
     * @param date
     * @return
     */
    public static Date getMonthBegin(Date date) {
        String newDateStr = formatDate(date, "yyyy-MM") + "-01";
        // formatDate(date, "yyyy-MM-dd");
        return stringToDateShort(newDateStr);
    }

    /**
     * 取月末时间
     *
     * @param date 日期
     * @return date
     */
    public static Date getMonthEnd(Date date) {
        int year = Integer.parseInt(formatDate(date, "yyyy"));
        int month = Integer.parseInt(formatDate(date, "MM"));
        int day = Integer.parseInt(formatDate(date, "dd"));

        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, 0, 0, 0);
        int monthLength = calendar.getActualMaximum(calendar.DAY_OF_MONTH);
        String newDateStr = formatDate(date, "yyyy") + "-" + formatDate(date, "MM") + "-";
        if (monthLength < 10) {
            newDateStr += "0" + monthLength;
        } else {
            newDateStr += "" + monthLength;
        }
        return stringToDateShort(newDateStr);
    }

    /**
     * 取月末时间
     *
     * @param date 日期
     * @return date
     */
    public static Date getMonthEndAndLastSecond(Date date) {
        int year = Integer.parseInt(formatDate(date, "yyyy"));
        int month = Integer.parseInt(formatDate(date, "MM"));
        int day = Integer.parseInt(formatDate(date, "dd"));

        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, 23, 59, 59);
        int monthLength = calendar.getActualMaximum(calendar.DAY_OF_MONTH);
        String newDateStr = formatDate(date, "yyyy") + "-" + formatDate(date, "MM") + "-";
        if (monthLength < 10) {
            newDateStr += "0" + monthLength;
        } else {
            newDateStr += "" + monthLength;
        }
        return stringToDateShort(newDateStr);
    }

    /**
     * 取旬初
     *
     * @param date
     * @return
     */
    public Date getPeriodBegin(Date date) {
        int days = Integer.parseInt(formatDate(date, "dd"));
        String newDateStr = formatDate(date, "yyyy-MM") + "-";
        if (days <= 10) {
            newDateStr += "01";
        } else if (days <= 20) {
            newDateStr += "11";
        } else {
            newDateStr += "21";
        }
        return stringToDateShort(newDateStr);
    }

    /**
     * 取旬末
     *
     * @param date
     * @return
     */
    public Date getPeriodEnd(Date date) {
        int days = Integer.parseInt(formatDate(date, "dd"));
        String newDateStr = formatDate(date, "yyyy-MM") + "-";
        if (days <= 10) {
            newDateStr += "10";
        } else if (days <= 20) {
            newDateStr += "20";
        } else {
            newDateStr = formatDate(getMonthEnd(date), "yyyy-MM-dd");
        }
        return stringToDateShort(newDateStr);
    }

    /**
     * 取季初
     *
     * @param date
     * @return
     */
    public Date getSeasonBegin(Date date) {
        int year = Integer.parseInt(formatDate(date, "yyyy"));
        int month = Integer.parseInt(formatDate(date, "MM"));
        String newDateStr = formatDate(date, "yyyy") + "-";
        if (month >= 1 && month <= 3) {
            newDateStr += "01-01";
        } else if (month >= 4 && month <= 6) {
            newDateStr += "04-01";
        } else if (month >= 7 && month <= 9) {
            newDateStr += "07-01";
        } else if (month >= 10 && month <= 12) {
            newDateStr += "10-01";
        }
        return stringToDateShort(newDateStr);
    }

    /**
     * 取季度末时间
     *
     * @param date 日期
     * @return date
     */
    public Date getSeasonEnd(Date date) {
        int year = Integer.parseInt(formatDate(date, "yyyy"));
        int month = Integer.parseInt(formatDate(date, "MM"));
        String newDateStr = formatDate(date, "yyyy") + "-";
        if (month >= 1 && month <= 3) {
            newDateStr += "03-31";
        } else if (month >= 4 && month <= 6) {
            newDateStr += "06-30";
        } else if (month >= 7 && month <= 9) {
            newDateStr += "09-30";
        } else if (month >= 10 && month <= 12) {
            newDateStr += "12-31";
        }
        return stringToDateShort(newDateStr);
    }

    /**
     * 取得时间描述 日 yyyy－mm－dd 月 yyyy年mm月 季 yyyy年第×季度 年 yyyy年
     *
     * @param granularity   粒度
     * @param statisticDate 时间
     * @return 时间对应粒度的描述
     */
    public String getTimedes(String granularity, String statisticDate) {
        String timedes = "";
        Date date = stringToDateShort(statisticDate);
        String year = "", month = "01", day = "01";
        year = DateUtils.getYear(date);
        month = DateUtils.getMonth(date);
        day = DateUtils.getDay(date);
        if (granularity.equals("1")) {// 日
            timedes = statisticDate;
        } else if (granularity.equals("4")) {// 月
            timedes = year + "年" + month + "月";

        } else if (granularity.equals("8")) {// 季
            String quarter = month + "-" + day;
            if (quarter.equals("03-31")) {
                timedes = year + "年 第1季度";
            } else if (quarter.equals("06-30")) {
                timedes = year + "年 第2季度";
            } else if (quarter.equals("09-30")) {
                timedes = year + "年 第3季度";
            } else if (quarter.equals("12-31")) {
                timedes = year + "年 第4季度";
            }
        } else if (granularity.equals("32")) {// 年
            timedes = year + "年";
        }
        return timedes;
    }

    /**
     * 取周初
     *
     * @param date
     * @return
     */
    public static Date getWeekBegin(Date date) {

        int year = Integer.parseInt(formatDate(date, "yyyy"));
        int month = Integer.parseInt(formatDate(date, "MM"));
        // 月份修正
        month = month - 1;
        int day = Integer.parseInt(formatDate(date, "dd"));

        GregorianCalendar gc = new GregorianCalendar(year, month, day);

        int week = GregorianCalendar.DAY_OF_WEEK - 1;

        if (week == 0) {
            week = 7;
        }

        gc.add(GregorianCalendar.DATE, 0 - week + 1);

        return gc.getTime();
    }

    /**
     * 取周末
     *
     * @param date
     * @return
     */
    public static Date getWeekEnd(Date date) {

        int year = Integer.parseInt(formatDate(date, "yyyy"));
        int month = Integer.parseInt(formatDate(date, "MM"));
        // 月份修正
        month = month - 1;
        int day = Integer.parseInt(formatDate(date, "dd"));

        GregorianCalendar gc = new GregorianCalendar(year, month, day);

        int week = GregorianCalendar.DAY_OF_WEEK - 1;

        if (week == 0) {
            week = 7;
        }
        gc.add(GregorianCalendar.DATE, 7 - week);

        return gc.getTime();
    }

    /**
     * 取得年初
     *
     * @param date
     * @return
     */
    public Date getYearBegin(Date date) {
        String newDateStr = formatDate(date, "yyyy") + "-01-01";
        return stringToDateShort(newDateStr);
    }

    /**
     * 是否为年末
     *
     * @param date 时间
     * @return
     */
    public Date getYearEnd(Date date) {
        String newDateStr = formatDate(date, "yyyy") + "-12-31";
        return stringToDateShort(newDateStr);
    }

    /**
     * 是否为旬末
     *
     * @param date 时间
     * @return 是或否
     */
    public boolean IsXperiodEnd(Date date) {

        boolean flag = false;

        String day = getDay(date);
        String month = getMonth(date);

        if (day.equalsIgnoreCase("10")) {
            flag = true;
        } else if (day.equalsIgnoreCase("20")) {
            flag = true;
        }

        return flag;
    }

    /**
     * 日期加N天
     * <p/>
     * 时间
     *
     * @return 加后的日期
     */
    public static String addDay(String s, int n) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

            Calendar cd = Calendar.getInstance();
            cd.setTime(sdf.parse(s));
            cd.add(Calendar.DATE, n);// 增加一天
            // cd.add(Calendar.MONTH, n);//增加一个月
            return sdf.format(cd.getTime());

        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 时间加N天
     *
     * @param date 时间
     * @param n    天数
     * @return 加后的Date
     */
    public static Date addDays(Date date, int n) {
        try {
            Calendar cd = Calendar.getInstance();
            cd.setTime(date);
            cd.add(Calendar.DATE, n);// 增加一天

            return cd.getTime();

        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 时间加N秒
     *
     * @param date 时间
     * @return 加后的Date
     */
    public static Date addSeconds(Date date, int n) {
        try {
            Calendar cd = Calendar.getInstance();
            cd.setTime(date);
            cd.add(Calendar.SECOND, n);// 增加一天

            return cd.getTime();

        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 时间加小时
     *
     * @param date 时间
     * @return 加后的Date
     */
    public static Date addHours(Date date, int n) {
        try {
            Calendar cd = Calendar.getInstance();
            cd.setTime(date);
            cd.add(Calendar.HOUR_OF_DAY, n);// 增加一小时

            return cd.getTime();

        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 时间加分钟
     *
     * @param date 时间
     * @return 加后的Date
     */
    public static Date addMinute(Date date, int n) {
        try {
            Calendar cd = Calendar.getInstance();
            cd.setTime(date);
            cd.add(Calendar.MINUTE, n);// 增加N分钟

            return cd.getTime();

        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 时间加N毫秒
     *
     * @param date 时间
     * @return 加后的Date
     */
    public static Date addMilltSeconds(Date date, int n) {
        try {
            Calendar cd = Calendar.getInstance();
            cd.setTime(date);
            cd.add(Calendar.MILLISECOND, n);//

            return cd.getTime();

        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 时间加N月
     *
     * @param date 时间
     * @return 加后的Date
     */
    public static Date addMonth(Date date, int n) {
        try {
            Calendar cd = Calendar.getInstance();
            cd.setTime(date);
            cd.add(Calendar.MONTH, n);

            return cd.getTime();

        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 时间加N年
     *
     * @param date 时间
     * @return 加后的Date
     */
    public static Date addYear(Date date, int n) {
        try {
            Calendar cd = Calendar.getInstance();
            cd.setTime(date);
            cd.add(Calendar.YEAR, n);

            return cd.getTime();

        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 获取本周第一天
     *
     * @param date 当前日期
     * @return
     */
    public static Date getWeekBegin2(Date date) {
        Calendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(Calendar.SUNDAY);
        c.setTime(date);
        c.set(Calendar.DAY_OF_WEEK, c.getFirstDayOfWeek()); // SUNDAY
        return getDayBegin(c.getTime());
    }

    /**
     * 获取本周第一天
     *
     * @param date 当前日期
     * @return
     */
    public static Date getWeekEnd2(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(getWeekBegin2(date));
        calendar.add(Calendar.DAY_OF_WEEK, 7);
        return getDayEnd(calendar.getTime());
    }

    /**
     * 返回当前日期减去毫秒数
     *
     * @param msec 毫秒数
     * @return
     */
    public static String getNowTimeMinusMsec(long msec) {
        Date now = new Date();
        Date nowMinusMsec = new Date(now.getTime() - msec);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowTime = dateFormat.format(nowMinusMsec);
        return nowTime;
    }

    /**
     * 字符串转换为日期
     *
     * @param dateString yyyy-MM-dd HH:mm:ss
     * @return 日期
     */
    public static Date getDateIncludeDateOrTime(String dateString) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

        Date result = null;
        if (dateString == null || "".equals(dateString.trim())) {
            return result;
        }
        try {
            if (dateString.indexOf(":") > 0) {
                result = dateTimeFormat.parse(dateString);

            } else {
                result = dateFormat.parse(dateString);
            }
        } catch (ParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 获取当前日期是星期几<br>
     *
     * @param dt
     * @return 当前日期是星期几
     */
    public static String getWeekOfDate(Date dt) {
        String[] weekDays = {"7", "1", "2", "3", "4", "5", "6"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    /**
     * 获取当前日期是星期几<br>
     *
     * @param dt
     * @return 当前日期是星期几
     */
    public static int getWeekOfDateInt(Date dt) {
        int[] weekDays = {7, 1, 2, 3, 4, 5, 6};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    /**
     * 例如11:42转换为11.42,不足1分钟的时间当1分钟算<br>
     *
     * @param dt
     * @return 例如11:42转换为11.42,不足1分钟的时间当1分钟算
     */
    public static double timeToDouble(Date dt) {
        return (dt.getMinutes() + 0.00d) / 100 + dt.getHours();
    }

    public static Date getDateAfter(Date date, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.set(Calendar.DATE, now.get(Calendar.DATE) + day);
        return now.getTime();
    }

    public static Date getMonthAfter(Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.set(Calendar.MONTH, now.get(Calendar.MONTH) + month);
        return now.getTime();
    }

    // 获取当月的第一天 2015-06-01 00:00:00
    public static Date getFirstDayOfThisMonth() {
        Date firstDayOfMonth = commonDateUtils.setDays(new Date(), 1);//设为当月第一天
        firstDayOfMonth = commonDateUtils.truncate(firstDayOfMonth, Calendar.DAY_OF_MONTH);//截取日期

        return firstDayOfMonth;
    }

    // 获取当月的最后一天 2015-06-30 23:59:59
    public static Date getLastDayOfThisMonth() {
        Date date = getFirstDayOfNextMonth();
        date = commonDateUtils.addDays(date, -1);//减一天

        date = commonDateUtils.setHours(date, 23);
        date = commonDateUtils.setMinutes(date, 59);
        date = commonDateUtils.setSeconds(date, 59);

        return date;
    }

    // 获取下月的第一天 2015-06-01 00:00:00
    public static Date getFirstDayOfNextMonth() {
        Date firstDayOfMonth = commonDateUtils.addMonths(new Date(), 1);//加一个月
        firstDayOfMonth = commonDateUtils.setDays(firstDayOfMonth, 1);//设为当月第一天
        firstDayOfMonth = commonDateUtils.truncate(firstDayOfMonth, Calendar.DAY_OF_MONTH);//截取日期

        return firstDayOfMonth;
    }

    // 当前日期加一个月 2015-06-01 00:00:00
    public static Date getNextDayOfNextMonth() {
        Date nextDate = commonDateUtils.addMonths(new Date(), 1);//加一个月
        nextDate = commonDateUtils.truncate(nextDate, Calendar.DAY_OF_MONTH);//截取日期

        return nextDate;
    }

    // 当前日期加一个月 2015-06-01 23:59:59
    public static Date getThisDayOfNextMonth() {
        Date date = commonDateUtils.addMonths(new Date(), 1);//加一个月
        date = commonDateUtils.addDays(date, -1);//减一天

        date = commonDateUtils.setHours(date, 23);
        date = commonDateUtils.setMinutes(date, 59);
        date = commonDateUtils.setSeconds(date, 59);

        return date;
    }

    // 获取下一年相同月份的第一天
    public static Date getFirstDayOfNextYear(Date d) {
        Date date = commonDateUtils.addYears(d, 1);// 加一年
        date = commonDateUtils.setDays(date, 1);// 设为当月第一天
        date = commonDateUtils.truncate(date, Calendar.DAY_OF_MONTH);// 截取日期

        return date;
    }

    // 当前日期加一年
    public static Date getThisDayOfNextYear(Date d) {
        Date date = commonDateUtils.addYears(d, 1);// 加一年
        date = commonDateUtils.addDays(date, -1);// 减一天

        date = commonDateUtils.setHours(date, 23);
        date = commonDateUtils.setMinutes(date, 59);
        date = commonDateUtils.setSeconds(date, 59);

        return date;
    }

    // 获取今年1月1号
    public static Date getFirstDayThisYear() {
        Date firstDayThisYear = getFirstDayOfThisMonth();
        firstDayThisYear.setMonth(0);
        firstDayThisYear = commonDateUtils.setYears(firstDayThisYear, getNowYear());// 设为当月第一天
        firstDayThisYear = commonDateUtils.truncate(firstDayThisYear, Calendar.DAY_OF_MONTH);// 截取日期
        return firstDayThisYear;
    }

    // 获取今年12月31号
    public static Date getLastDayThisYear() {
        Date firstDayThisYear = getFirstDayOfThisMonth();
        firstDayThisYear.setMonth(0);
        firstDayThisYear = commonDateUtils.setYears(firstDayThisYear, getNowYear());// 设为当月第一天
        Date firstDayNextYear = commonDateUtils.addYears(firstDayThisYear, 1);// 设为当月第一天
        return commonDateUtils.addSeconds(firstDayNextYear, -1);// 设为当月第一天
    }

    // 获取当天日期零点
    public static Date getToday() {
        return commonDateUtils.truncate(new Date(), Calendar.DAY_OF_MONTH);
    }

    // 获取明天零点
    public static Date getTomorrow() {
        Date tmr = commonDateUtils.addDays(new Date(), 1);//加一天

        return commonDateUtils.truncate(tmr, Calendar.DAY_OF_MONTH);
    }

    // 获取某个日期的零点
    public static Date getThatDay(Date date) {
        return commonDateUtils.truncate(date, Calendar.DAY_OF_MONTH);
    }

    // 获取某个日期第二天零点
    public static Date getThatTomorrow(Date date) {
        Date tmr = commonDateUtils.addDays(date, 1);// 加一天
        return commonDateUtils.truncate(tmr, Calendar.DAY_OF_MONTH);
    }

    public static Date getMinuteAfter(Date date, Integer minute) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(Calendar.MINUTE, minute);
        return c.getTime();
    }

    public static boolean isSameDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);

        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);

        boolean isSameYear = cal1.get(Calendar.YEAR) == cal2
                .get(Calendar.YEAR);
        boolean isSameMonth = isSameYear
                && cal1.get(Calendar.MONTH) == cal2.get(Calendar.MONTH);
        boolean isSameDate = isSameMonth
                && cal1.get(Calendar.DAY_OF_MONTH) == cal2
                .get(Calendar.DAY_OF_MONTH);

        return isSameDate;
    }

    //获取当天的开始时间
    public static Date getDayBegin(Date day) {
        Calendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        return cal.getTime();
    }

    //获取当天的结束时间
    public static Date getDayEnd(Date day) {
        Calendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        return cal.getTime();
    }

    //获取当天的开始时间
    public static Date getTodayBegin() {
        Calendar cal = new GregorianCalendar();
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        return cal.getTime();
    }

    //获取当天的结束时间
    public static Date getTodayEnd() {
        Calendar cal = new GregorianCalendar();
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        return cal.getTime();
    }

    //获取本周的开始时间
    public static Date getBeginDayOfWeek() {
        Date date = new Date();

        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(Calendar.DATE, 2 - dayofweek);
        return getDayStartTime(cal.getTime());
    }

    //获取本周的结束时间
    public static Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getBeginDayOfWeek());
        cal.add(Calendar.DAY_OF_WEEK, 6);
        Date weekEndSta = cal.getTime();
        return getDayEndTime(weekEndSta);
    }

    //获取本月的开始时间
    public static Date getBeginDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(getNowYear(), getNowMonth() - 1, 1);
        return getDayStartTime(calendar.getTime());
    }

    //获取本月的结束时间
    public static Date getEndDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(getNowYear(), getNowMonth() - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(getNowYear(), getNowMonth() - 1, day);
        return getDayEndTime(calendar.getTime());
    }

    //获取某个日期的开始时间
    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), 0, 0, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    //获取某个日期的结束时间
    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), 23, 59, 59);
        calendar.set(Calendar.MILLISECOND, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    //获取某个日期的结束时间
    public static Date getThatDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), 23, 59, 59);
        calendar.set(Calendar.MILLISECOND, 999);
        return new Date(calendar.getTimeInMillis());
    }

    //获取今年是哪一年
    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar) Calendar.getInstance();
        gc.setTime(date);
        return Integer.valueOf(gc.get(1));
    }

    //获取本月是哪一月
    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar) Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static int getDayOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(Calendar.DAY_OF_YEAR);
    }

    //获取上周的开始时间
    @SuppressWarnings("unused")
    public static Date getBeginDayOfLastWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(Calendar.DATE, 2 - dayofweek - 7);
        return getDayStartTime(cal.getTime());
    }

    //获取上月的开始时间
    public static Date getBeginDayOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(getNowYear(), getNowMonth() - 2, 1);
        return getDayStartTime(calendar.getTime());
    }

    public static String toGMTString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.UK);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(date);
    }


    /**
     * 切割時間段
     *
     * @param dateType 切割类型 M/D/H/N -->每月/每天/每小時/每分鐘
     * @param dBegin   yyyy-MM-dd HH:mm:ss
     * @param dEnd     yyyy-MM-dd HH:mm:ss
     * @return
     */
    public static List<String> findDates(String dateType, Date dBegin, Date dEnd, String dateFormat) throws Exception {
        List<String> listDate = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat(Optional.ofNullable(dateFormat).orElse("yyyy-MM-dd HH:mm:ss"));

        Date dBeginDay = DateUtils.getThatDay(dBegin);
        Date dEndDay = DateUtils.getThatDayEndTime(dEnd);

        listDate.add(sdf.format(dBeginDay));
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBeginDay);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEndDay);
        while (calEnd.after(calBegin)) {
            switch (dateType) {
                case "M":
                    calBegin.add(Calendar.MONTH, 1);
                    break;
                case "D":
                    calBegin.add(Calendar.DAY_OF_YEAR, 1);
                    break;
                case "H":
                    calBegin.add(Calendar.HOUR, 1);
                    break;
                case "N":
                    calBegin.add(Calendar.SECOND, 1);
                    break;
                default:
                    break;
            }
            if (calEnd.after(calBegin)) {
                listDate.add(sdf.format(calBegin.getTime()));
            }
        }
        return listDate;
    }

    /**
     * 日期与日期+时间比较
     * @param date1 比较日期1
     * @param date2 比较日期2
     * @param dateTime 比较日期2的时分秒
     * @return
     * @throws Exception
     */
    public static Boolean dateAndTimeBefore(Date date1, Date date2, Date dateTime) throws Exception {

		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
		String date2Format = dateFormat.format(date2);
		
		SimpleDateFormat bartDateFormat = new SimpleDateFormat("HH:mm:ss");
		String dateTimeFormat = bartDateFormat.format(dateTime);


		SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date newDate = dateFormat1.parse(date2Format + " " + dateTimeFormat);
		return date1.before(newDate);
	}

    /**
     * 获取两个日期之间的所有日期，默认日期格式为yyyy-MM-dd
     * @param startTime
     * @param endTime
     * @return
     */
    public static List<String> getTwoDateBetweenDayAllString(String startTime, String endTime) {
        return getTwoDateBetweenDayAllString(startTime,endTime,"yyyy-MM-dd");
    }
    /**
     * 获取两个日期之间的所有日期,自定义日期格式
     * @param startTime
     * @param endTime
     * @return
     */
    public static List<String> getTwoDateBetweenDayAllString(String startTime, String endTime, String definedDateFormat) {

        // 返回的日期集合
        List<String> days = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat definedSimpleDateFormat = new SimpleDateFormat(definedDateFormat);
        try {
            Date start = dateFormat.parse(startTime);
            Date end = dateFormat.parse(endTime);

            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);

            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(Calendar.DATE, +1);// 日期加1(包含结束)
            while (tempStart.before(tempEnd)) {
                days.add(definedSimpleDateFormat.format(tempStart.getTime()));
                tempStart.add(Calendar.DAY_OF_YEAR, 1);
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return days;

    }

    public static Date getNext(Date date) {

        Calendar calendar = Calendar.getInstance();

        calendar.setTime(date);

        calendar.add(Calendar.DATE, 1);

        return calendar.getTime();

    }
}
