package cn.com.poc.common.utils;

import cn.com.yict.framemax.core.utils.BeanUtils;
import cn.com.yict.framemax.core.utils.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONPath;
import org.apache.log4j.Logger;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 系统Json 工具类
 * <p>
 *
 * @see JSON
 */
public final class JsonUtils {

    private static Logger log = Logger.getLogger(JsonUtils.class);

    private JsonUtils() {
    }

    /**
     * 转换Java Bean 为 json
     */
    public static String serialize(Object o) {
        if(o ==null){
            return null;
        }
        return JSON.serialize(o);
    }

    /**
     * 转换Java Bean 为 json 附加了个时间格式参数
     *
     * @param o
     * @param dateFormat
     * @return
     *//*
    public static String serialize(Object o, String dateFormat) {
		if(StringUtils.isEmpty(dateFormat)) {
			return JSON.serialize(o);
		}
		return com.alibaba.fastjson.JSON.toJSONStringWithDateFormat(o, dateFormat);
	}*/

    /**
     * json 转 javabean
     *
     * @param json
     * @return
     */
    public static <T> T deSerialize(String json, Class<T> clazz) {
        try {
            return JSON.deSerialize(clazz, json);
        } catch (Exception e) {
            log.error(e);
            return null;
        }
    }


    /**
     * json 转 javabean
     *
     * @param json
     * @return
     */
    public static <T> T deSerialize(String json, Type type) {
        try {
            return JSON.deSerialize(type, json);
        } catch (Exception e) {
            log.error(e);
            return null;
        }
    }

    /**
     * 转换Java Bean 为 HashMap
     */
    @SuppressWarnings("unchecked")
    public static Map<String, Object> beanToMap(Object o) {
        try {
            String json = serialize(o);
            return JSON.deSerialize(Map.class, json);
        } catch (Exception e) {
            log.error(e);
            return null;
        }
    }

    /**
     * 转换Json String 为 HashMap
     */
    @SuppressWarnings("unchecked")
    public static Map<String, Object> jsonToMap(String json,
                                                boolean collToString) {
        try {
            Map<String, Object> map = JSON.deSerialize(Map.class, json);
            if (collToString) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    if (entry.getValue() instanceof Collection
                            || entry.getValue() instanceof Map) {
                        entry.setValue(serialize(entry.getValue()));
                    }
                }
            }
            return map;
        } catch (Exception e) {
            log.error(e);
            return null;
        }
    }

    /**
     * List 转换成json
     *
     * @param list
     * @return
     */
    public static String listToJson(List<?> list) {
        return JSON.serialize(list);
    }


    public static <T> List<T> parseArray(String json, String jsonPath, Class<T> clazz) {
        Object read = JSONPath.read(json, jsonPath);

        if (read instanceof ArrayList) {
            return (List<T>) read;
        }

        return JSONArray.parseArray(read.toString(), clazz);
    }

    public static <T> T convert(Object object, Type type) {

        if (object instanceof String) {
            try {
                return deSerialize(object.toString(), type);
            } catch (Exception e) {
            }

        }

        if (BeanUtils.isSimpleValueType(object.getClass())) {
            return (T) object;
        }

        String serialize = serialize(object);
        return deSerialize(serialize, type);
    }


}
