package cn.com.poc.message.service.impl;

import cn.com.poc.agent_application.aggregate.AgentApplicationMallService;
import cn.com.poc.agent_application.entity.BizAgentApplicationPublishEntity;
import cn.com.poc.agent_application.service.BizAgentApplicationDialoguesRecordService;
import cn.com.poc.agent_application.service.BizAgentApplicationPublishService;
import cn.com.poc.message.entity.AgentApplicationClickEventMessage;
import cn.com.poc.message.service.AgentApplicationConsumerService;
import cn.com.poc.message.topic.AgentApplicationTopic;
import cn.com.yict.framemax.core.service.BaseService;
import cn.com.yict.framemax.tumbleweed.client.annotation.Consumer;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class AgentApplicationConsumerServiceImpl implements AgentApplicationConsumerService {


    @Resource
    private BizAgentApplicationPublishService bizAgentApplicationPublishService;

    @Resource
    private AgentApplicationMallService agentApplicationMallService;


    @Override
    @Consumer(topic = AgentApplicationTopic.AGENT_APPLICATION_CLICK_EVENT, retry = true)
    public void clickEvent(AgentApplicationClickEventMessage message) throws Exception {
        BizAgentApplicationPublishEntity agentApplicationPublishEntity = bizAgentApplicationPublishService.getByAgentId(message.getAgentId());
        if (agentApplicationPublishEntity != null) {
            Integer publishId = agentApplicationPublishEntity.getId();
            agentApplicationMallService.addClickNumber(publishId);
        }
    }
}
