package cn.com.poc.thirdparty.resource.baidu.api;

import cn.com.poc.common.utils.http.LocalHttpClient;
import cn.com.poc.thirdparty.resource.baidu.entity.result.BaiduTokenResult;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

/**
 * @author alex.yao
 * @date 2023/3/6
 **/
@Component
public class BaiduTokenAPI implements BaiduBaseApi {

    public BaiduTokenResult getToken(String apiKey, String secretKey) {
        Assert.notNull(apiKey);
        Assert.notNull(secretKey);
        HttpUriRequest httpUriRequest = RequestBuilder.post()
                .setUri(BASE_API + "oauth/2.0/token")
                .setHeader(jsonHeader)
                .setHeader(acceptHeader)
                .addParameter("grant_type", "client_credentials")
                .addParameter("client_id",apiKey )
                .addParameter("client_secret", secretKey)
                .build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaiduTokenResult.class);
    }
}
