package cn.com.poc.thirdparty.resource.baidu.api;

import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.common.utils.http.LocalHttpClient;
import cn.com.poc.thirdparty.resource.baidu.entity.response.BaiduTextTransResponse;
import cn.com.poc.thirdparty.resource.baidu.entity.result.textTrans.BaiduTextTransResult;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.nio.charset.StandardCharsets;

/**
 * @author alex.yao
 * @date 2023/11/28
 **/
@Component
public class BaiduTransApi implements BaiduBaseApi {

    /**
     * 文本翻译-通用版
     *
     * @param accessToken
     * @param response
     * @return
     */
    public BaiduTextTransResult textTrans(String accessToken, BaiduTextTransResponse response) {
        Assert.notNull(response);
        Assert.notNull(accessToken);
        String body = JsonUtils.serialize(response);
        HttpUriRequest httpUriRequest = RequestBuilder.post()
                .setUri(BASE_API + "rpc/2.0/mt/texttrans/v1")
                .setHeader(jsonHeader)
                .addParameter(ACCESS_TOKEN, accessToken)
                .setEntity(new StringEntity(body, StandardCharsets.UTF_8))
                .build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaiduTextTransResult.class);

    }

    /**
     * 文本翻译-词典版
     */
    public BaiduTextTransResult textTransDict(String accessToken, BaiduTextTransResponse response) {
        Assert.notNull(response);
        Assert.notNull(accessToken);
        String body = JsonUtils.serialize(response);
        HttpUriRequest httpUriRequest = RequestBuilder.post()
                .setUri(BASE_API + "rpc/2.0/mt/texttrans-with-dict/v1")
                .setHeader(jsonHeader)
                .addParameter(ACCESS_TOKEN, accessToken)
                .setEntity(new StringEntity(body, StandardCharsets.UTF_8))
                .build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaiduTextTransResult.class);
    }

}
