package cn.com.poc.thirdparty.resource.baidu.constants;

/**
 * @author alex.yao
 * @date 2023/3/7
 **/
public enum BaiduApiErrorEnum {

    //业务错误码
    SUCCESS(0, "SUCCESS"),
    PIC_NOT_HAS_FACE(222202, "图片中没有人脸"),
    IAMGE_CHECK_FALIL(222203, "无法解析人脸"),
    FACE_SIZE_IS_TOO_SAMIL(222213, "人脸尺寸过小，请保证人脸区域在64*64以上"),
    IMAGE_SIZE_IS_TOO_SMAIL(222309, "图片尺寸过小，请使用清晰的图片"),
    FACE_IS_COVERED(223113, "请勿遮挡面部"),
    FACE_IS_FUZZY(223114, "人脸模糊"),
    FACE_LIGHT_IS_NOT_GOOD(223115, "到光线适宜的地方拍摄"),
    INCOMPLETE_FACE(223116, "请勿遮挡面部"),
    FACE_NOT_FORWARD(223129, "请使用面向正前方的人脸图片"),

    LEFT_EYE_IS_OCCLUSION(223121, "勿遮挡左眼"),
    RIGHT_EYE_IS_OCCLUSION(223122, "请勿遮挡右眼"),
    LEFT_CHEEK_IS_OCCLUSION(223123, "请勿遮挡左脸颊"),
    RIGHT_CHEEK_IS_OCCLUSION(223124, "请勿遮挡右脸颊"),
    CHIN_CONTOUR_IS_OCCLUSION(223125, "请勿遮挡下巴"),
    NODE_IS_OCCLUSION(223126, "请勿遮挡鼻子"),
    MOUTH_IS_OCCLUSION(223127, "请勿遮挡嘴巴"),
    PORN(222307, "图片非法 鉴黄未通过"),
    SENSITIVE_PERSON(222308, "图片非法 含有政治敏感人物"),
    IMAGE_SIZE_IS_TOO_LARGE(222304, "请确保图片尺寸在1920x1080以下"),


    //人脸属性编辑 错误码
    IMAGE_SIZE_IS_TO_SMALL(222309, "图片尺寸过小，请使用清晰的图片"),
    FACE_SIZE_IS_TO_SMALL(222213, "人脸尺寸过小，请保证人脸区域在64*64以上"),
    FACE_ARE_CARTOON_IMAGES(222214, "请使用非卡通的人脸图像"),
    FACE_QUALITY_IS_NOT_ACCEPTABLE(222215, "人脸属性编辑处理该图像失败，请使用其他图片"),
    FACE_EDIT_ATTR_FAIL(222216, "人脸属性编辑服务不可用，请重试");


    private Integer errorCode;

    private String errorMessage;


    BaiduApiErrorEnum(Integer errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public Integer getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

}
