package cn.com.poc.thirdparty.service.impl;

import cn.com.poc.thirdparty.resource.demand.ai.aggregate.AIDialogueService;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelDemandResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelResponse;
import cn.com.poc.thirdparty.service.LLMService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.BufferedReader;

/**
 * @author alex.yao
 * @date 2023/11/23
 **/
@Service
public class LLMServiceImpl implements LLMService {

    private final Logger logger = LoggerFactory.getLogger(LLMService.class);

    @Resource
    private AIDialogueService aiDialogueService;

    @Override
    public LargeModelDemandResult chat(LargeModelResponse response) {
        try {
            return aiDialogueService.poly(response);
        } catch (Exception e) {
            logger.warn(e.getMessage());
        }
        return null;
    }


    @Override
    public BufferedReader chatChunk(LargeModelResponse request) throws Exception {
        return aiDialogueService.polyStream(request);
    }
}
