package cn.com.poc.agent_application.convert;

import cn.com.poc.agent_application.domain.AgentApplicationBaseInfo;
import cn.com.poc.agent_application.domain.AgentApplicationCommConfig;
import cn.com.poc.agent_application.domain.AgentApplicationCommModelConfig;
import cn.com.poc.agent_application.domain.AgentApplicationKnowledgeConfig;
import cn.com.poc.agent_application.dto.AgentApplicationMallInfoDto;
import cn.com.poc.agent_application.entity.BizAgentApplicationPublishEntity;
import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.agent_application.model.BizAgentApplicationMallModel;
import cn.com.poc.agent_application.entity.BizAgentApplicationMallEntity;
import cn.com.poc.agent_application.dto.BizAgentApplicationMallDto;
import cn.com.poc.agent_application.query.MallAgentApplicationQueryItem;
import cn.com.poc.agent_application.service.BizAgentApplicationPublishService;
import cn.com.poc.agent_application.service.impl.BizAgentApplicationPublishServiceImpl;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.SpringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class BizAgentApplicationMallConvert {

    public static BizAgentApplicationMallEntity modelToEntity(BizAgentApplicationMallModel model) {
        BizAgentApplicationMallEntity entity = new BizAgentApplicationMallEntity();
        entity.setId(model.getId());
        entity.setAgentPublishId(model.getAgentPublishId());
        entity.setAgentType(model.getAgentType());
        entity.setCategoryId(model.getCategoryId());
        entity.setCollectNumber(model.getCollectNumber());
        entity.setClickNumber(model.getClickNumber());
        entity.setIsCopy(model.getIsCopy());
        entity.setIsSale(model.getIsSale());
        entity.setPopularity(model.getPopularity());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifiedTime(model.getModifiedTime());
        return entity;
    }

    public static BizAgentApplicationMallModel entityToModel(BizAgentApplicationMallEntity entity) {
        BizAgentApplicationMallModel model = new BizAgentApplicationMallModel();
        model.setId(entity.getId());
        model.setAgentPublishId(entity.getAgentPublishId());
        model.setCategoryId(entity.getCategoryId());
        model.setAgentType(entity.getAgentType());
        model.setCollectNumber(entity.getCollectNumber());
        model.setClickNumber(entity.getClickNumber());
        model.setIsCopy(entity.getIsCopy());
        model.setIsSale(entity.getIsSale());
        model.setPopularity(entity.getPopularity());
        return model;
    }

    public static BizAgentApplicationMallDto entityToDto(BizAgentApplicationMallEntity entity) throws Exception {
        BizAgentApplicationMallDto dto = new BizAgentApplicationMallDto();


        BizAgentApplicationPublishService agentApplicationPublishService = SpringUtils.getBean(BizAgentApplicationPublishServiceImpl.class);
        BizAgentApplicationPublishEntity publishEntity = agentApplicationPublishService.get(entity.getAgentPublishId());

        AgentApplicationBaseInfo baseInfo = new AgentApplicationBaseInfo();
        if (publishEntity != null) {
            baseInfo.setMemberId(publishEntity.getMemberId());
            baseInfo.setAgentId(publishEntity.getAgentId());
            baseInfo.setAgentTitle(publishEntity.getAgentTitle());
            baseInfo.setAgentAvatar(publishEntity.getAgentAvatar());
            baseInfo.setAgentDesc(publishEntity.getAgentDesc());
            baseInfo.setAgentSystem(publishEntity.getAgentSystem());
            baseInfo.setAgentPublishStatus(publishEntity.getAgentPublishStatus());
            baseInfo.setPublishTime(publishEntity.getPublishTime());
        }

        AgentApplicationCommConfig commConfig = new AgentApplicationCommConfig();
        if (publishEntity != null) {
            commConfig.setPreamble(publishEntity.getPreamble());
            commConfig.setFeaturedQuestions(publishEntity.getFeaturedQuestions());
            commConfig.setContinuousQuestionStatus(publishEntity.getContinuousQuestionStatus());
            commConfig.setContinuousQuestionSystem(publishEntity.getContinuousQuestionSystem());
            commConfig.setContinuousQuestionTurn(publishEntity.getContinuousQuestionTurn());
            commConfig.setVariableStructure(publishEntity.getVariableStructure());
            commConfig.setIsLongMemory(publishEntity.getIsLongMemory());
        }

        AgentApplicationKnowledgeConfig knowledgeConfig = new AgentApplicationKnowledgeConfig();
        if (publishEntity != null) {
            knowledgeConfig.setKnowledgeIds(publishEntity.getKnowledgeIds());
        }

        AgentApplicationCommModelConfig commModelConfig = new AgentApplicationCommModelConfig();
        if (publishEntity != null) {
            commModelConfig.setLargeModel(publishEntity.getLargeModel());
            commModelConfig.setTopP(publishEntity.getTopP());
            commModelConfig.setCommunicationTurn(publishEntity.getCommunicationTurn());
        }

        dto.setId(entity.getId());
        dto.setAgentType(entity.getAgentType());
        dto.setCollectNumber(entity.getCollectNumber());
        dto.setClickNumber(entity.getClickNumber());
        dto.setBaseInfo(baseInfo);
        dto.setCommConfig(commConfig);
        dto.setKnowledgeConfig(knowledgeConfig);
        dto.setCommModelConfig(commModelConfig);
        if (publishEntity != null) {
            dto.setUnitIds(publishEntity.getUnitIds());
        }

        dto.setIsCopy(entity.getIsCopy());
        dto.setIsSale(entity.getIsSale());
        dto.setPopularity(entity.getPopularity());

        return dto;
    }

    public static BizAgentApplicationMallDto itemToDto(MallAgentApplicationQueryItem item) throws Exception {
        BizAgentApplicationMallDto dto = new BizAgentApplicationMallDto();


        BizAgentApplicationPublishService agentApplicationPublishService = SpringUtils.getBean(BizAgentApplicationPublishServiceImpl.class);
        BizAgentApplicationPublishEntity publishEntity = agentApplicationPublishService.get(item.getAgentPublishId());

        if (publishEntity != null) {
            AgentApplicationBaseInfo baseInfo = new AgentApplicationBaseInfo();
            baseInfo.setMemberId(publishEntity.getMemberId());
            baseInfo.setAgentId(publishEntity.getAgentId());
            baseInfo.setAgentTitle(publishEntity.getAgentTitle());
            baseInfo.setAgentAvatar(publishEntity.getAgentAvatar());
            baseInfo.setAgentDesc(publishEntity.getAgentDesc());
            baseInfo.setAgentSystem(publishEntity.getAgentSystem());
            baseInfo.setAgentPublishStatus(publishEntity.getAgentPublishStatus());
            baseInfo.setPublishTime(publishEntity.getPublishTime());

            AgentApplicationCommConfig commConfig = new AgentApplicationCommConfig();
            commConfig.setPreamble(publishEntity.getPreamble());
            commConfig.setFeaturedQuestions(publishEntity.getFeaturedQuestions());
            commConfig.setContinuousQuestionStatus(publishEntity.getContinuousQuestionStatus());
            commConfig.setContinuousQuestionSystem(publishEntity.getContinuousQuestionSystem());
            commConfig.setContinuousQuestionTurn(publishEntity.getContinuousQuestionTurn());
            commConfig.setVariableStructure(publishEntity.getVariableStructure());
            commConfig.setIsLongMemory(publishEntity.getIsLongMemory());

            AgentApplicationKnowledgeConfig knowledgeConfig = new AgentApplicationKnowledgeConfig();
            knowledgeConfig.setKnowledgeIds(publishEntity.getKnowledgeIds());

            AgentApplicationCommModelConfig commModelConfig = new AgentApplicationCommModelConfig();
            commModelConfig.setLargeModel(publishEntity.getLargeModel());
            commModelConfig.setTopP(publishEntity.getTopP());
            commModelConfig.setCommunicationTurn(publishEntity.getCommunicationTurn());

            dto.setUnitIds(publishEntity.getUnitIds());
            dto.setBaseInfo(baseInfo);
            dto.setCommConfig(commConfig);
            dto.setKnowledgeConfig(knowledgeConfig);
            dto.setCommModelConfig(commModelConfig);
        }

        dto.setId(item.getId());
        dto.setAgentType(item.getAgentType());
        dto.setCollectNumber(item.getCollectNumber());
        dto.setClickNumber(item.getClickNumber());
        dto.setIsCopy(item.getIsCopy());
        dto.setIsSale(item.getIsSale());
        dto.setPopularity(item.getPopularity());
        return dto;
    }

    public static BizAgentApplicationMallEntity dtoToEntity(BizAgentApplicationMallDto dto) {
        BizAgentApplicationMallEntity entity = new BizAgentApplicationMallEntity();
        entity.setId(dto.getId());
        entity.setAgentPublishId(dto.getAgentPublishId());
        entity.setAgentType(dto.getAgentType());
        entity.setCategoryId(dto.getCategoryId());
        entity.setCollectNumber(dto.getCollectNumber());
        entity.setClickNumber(dto.getClickNumber());
        entity.setIsCopy(dto.getIsCopy());
        entity.setIsSale(dto.getIsSale());
        entity.setPopularity(dto.getPopularity());
        return entity;
    }

    public static AgentApplicationMallInfoDto entityToInfoDto(BizAgentApplicationMallEntity entity) {
        AgentApplicationMallInfoDto dto = new AgentApplicationMallInfoDto();
        dto.setAgentPublishId(entity.getAgentPublishId());
        dto.setCategoryId(entity.getCategoryId());
        dto.setIsCopy(entity.getIsCopy());
        dto.setIsSale(entity.getIsSale());
        dto.setLaunchTime(entity.getModifiedTime());
        return dto;
    }


}