package cn.com.poc.agent_application.convert;	

import cn.com.poc.agent_application.model.BizMemberAgentApplicationCollectModel;
import cn.com.poc.agent_application.entity.BizMemberAgentApplicationCollectEntity;
import cn.com.poc.agent_application.dto.BizMemberAgentApplicationCollectDto;

public class BizMemberAgentApplicationCollectConvert {

    public static BizMemberAgentApplicationCollectEntity modelToEntity(BizMemberAgentApplicationCollectModel model){
        BizMemberAgentApplicationCollectEntity entity = new BizMemberAgentApplicationCollectEntity();
        entity.setId(model.getId());
        entity.setMemberId(model.getMemberId());
        entity.setAgentId(model.getAgentId());
        entity.setIsCollect(model.getIsCollect());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizMemberAgentApplicationCollectModel entityToModel(BizMemberAgentApplicationCollectEntity entity){
        BizMemberAgentApplicationCollectModel model = new BizMemberAgentApplicationCollectModel();
        model.setId(entity.getId());
        model.setMemberId(entity.getMemberId());
        model.setAgentId(entity.getAgentId());
        model.setIsCollect(entity.getIsCollect());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }
    
    public static BizMemberAgentApplicationCollectDto entityToDto(BizMemberAgentApplicationCollectEntity entity){
        BizMemberAgentApplicationCollectDto dto = new BizMemberAgentApplicationCollectDto();
        dto.setId(entity.getId());
        dto.setMemberId(entity.getMemberId());
        dto.setAgentId(entity.getAgentId());
        dto.setIsCollect(entity.getIsCollect());
        dto.setIsDeleted(entity.getIsDeleted());
        dto.setCreator(entity.getCreator());
        dto.setCreatedTime(entity.getCreatedTime());
        dto.setModifier(entity.getModifier());
        dto.setModifiedTime(entity.getModifiedTime());
        return dto;
    }

    public static BizMemberAgentApplicationCollectEntity dtoToEntity(BizMemberAgentApplicationCollectDto dto){
        BizMemberAgentApplicationCollectEntity entity = new BizMemberAgentApplicationCollectEntity();
        entity.setId(dto.getId());
        entity.setMemberId(dto.getMemberId());
        entity.setAgentId(dto.getAgentId());
        entity.setIsCollect(dto.getIsCollect());
        entity.setIsDeleted(dto.getIsDeleted());
        entity.setCreator(dto.getCreator());
        entity.setCreatedTime(dto.getCreatedTime());
        entity.setModifier(dto.getModifier());
        entity.setModifiedTime(dto.getModifiedTime());
        return entity;
    }
}