package cn.com.poc.agent_application.model;

import java.io.Serializable;

import cn.com.yict.framemax.data.model.BaseModelClass;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Version;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

/**
 * Model class for biz_agent_application_mall
 * 应用广场
 */
@Entity
@Table(name = "biz_agent_application_mall")
@DynamicInsert
@DynamicUpdate
public class BizAgentApplicationMallModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * id
     * 自增ID
     */
    private java.lang.Integer id;

    @Column(name = "id", length = 10)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public java.lang.Integer getId() {
        return this.id;
    }

    public void setId(java.lang.Integer id) {
        this.id = id;
        super.addValidField("id");
    }


    /**
     * agent_publish_id
     * 发布应用的ID
     */
    private java.lang.Integer agentPublishId;

    @Column(name = "agent_publish_id", length = 10)
    public java.lang.Integer getAgentPublishId() {
        return this.agentPublishId;
    }

    public void setAgentPublishId(java.lang.Integer agentPublishId) {
        this.agentPublishId = agentPublishId;
        super.addValidField("agentPublishId");
    }


    /**
     * agent_type
     * 应用类型
     */
    private java.lang.String agentType;

    @Column(name = "agent_type", length = 200)
    public java.lang.String getAgentType() {
        return this.agentType;
    }

    public void setAgentType(java.lang.String agentType) {
        this.agentType = agentType;
        super.addValidField("agentType");
    }

    /**
     * category_id
     * 应用分类ID
     */
    private java.lang.Integer categoryId;

    @Column(name = "category_id", length = 10)
    public java.lang.Integer getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(java.lang.Integer categoryId) {
        this.categoryId = categoryId;
        super.addValidField("categoryId");
    }


    /**
     * collect_number
     * 收藏人数
     */
    private java.lang.Integer collectNumber;

    @Column(name = "collect_number", length = 10)
    public java.lang.Integer getCollectNumber() {
        return this.collectNumber;
    }

    public void setCollectNumber(java.lang.Integer collectNumber) {
        this.collectNumber = collectNumber;
        super.addValidField("collectNumber");
    }

    /**
     * click_number
     * 点击次数
     */
    private java.lang.Integer clickNumber;

    @Column(name = "click_number", length = 10)
    public java.lang.Integer getClickNumber() {
        return this.clickNumber;
    }

    public void setClickNumber(java.lang.Integer clickNumber) {
        this.clickNumber = clickNumber;
        super.addValidField("clickNumber");
    }


    /**
     * is_copy
     * 是否允许被复制 1、Y 是 2、N 否
     */
    private java.lang.String isCopy;

    @Column(name = "is_copy", length = 1)
    public java.lang.String getIsCopy() {
        return this.isCopy;
    }

    public void setIsCopy(java.lang.String isCopy) {
        this.isCopy = isCopy;
        super.addValidField("isCopy");
    }

    /**
     * is_sale
     * 是否上架应用 1、Y 是 2、N 否
     */
    private java.lang.String isSale;

    @Column(name = "is_sale", length = 1)
    public java.lang.String getIsSale() {
        return this.isSale;
    }

    public void setIsSale(java.lang.String isSale) {
        this.isSale = isSale;
        super.addValidField("isSale");
    }

    /**
     * popularity
     * 应用热度
     */
    private java.lang.Double popularity;

    @Column(name = "popularity", length = 10)
    public java.lang.Double getPopularity() {
        return this.popularity;
    }

    public void setPopularity(java.lang.Double popularity) {
        this.popularity = popularity;
        super.addValidField("popularity");
    }

    /**
     * is_deleted
     * 是否删除 1、Y 是 2、N 否
     */
    private java.lang.String isDeleted;

    @Column(name = "is_deleted", length = 1)
    public java.lang.String getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(java.lang.String isDeleted) {
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }


    /**
     * CREATOR
     * 创建人
     */
    private java.lang.String creator;

    @Column(name = "CREATOR", length = 50)
    public java.lang.String getCreator() {
        return this.creator;
    }

    public void setCreator(java.lang.String creator) {
        this.creator = creator;
        super.addValidField("creator");
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    @Column(name = "CREATED_TIME", length = 19)
    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }


    /**
     * MODIFIER
     * 修改人
     */
    private java.lang.String modifier;

    @Column(name = "MODIFIER", length = 50)
    public java.lang.String getModifier() {
        return this.modifier;
    }

    public void setModifier(java.lang.String modifier) {
        this.modifier = modifier;
        super.addValidField("modifier");
    }


    /**
     * MODIFIED_TIME
     * 修改时间
     */
    private java.util.Date modifiedTime;

    @Column(name = "MODIFIED_TIME", length = 19)
    public java.util.Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(java.util.Date modifiedTime) {
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }


    /**
     * SYS_VERSION
     * 版本号
     */
    private java.lang.Integer sysVersion;

    @Column(name = "SYS_VERSION", length = 10)
    @Version
    public java.lang.Integer getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(java.lang.Integer sysVersion) {
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }


}