package cn.com.poc.agent_application.schedule;

import cn.com.poc.agent_application.entity.BizAgentApplicationDialoguesRecordEntity;
import cn.com.poc.agent_application.entity.BizAgentApplicationMallEntity;
import cn.com.poc.agent_application.entity.BizAgentApplicationPublishEntity;
import cn.com.poc.agent_application.service.BizAgentApplicationDialoguesRecordService;
import cn.com.poc.agent_application.service.BizAgentApplicationMallService;
import cn.com.poc.agent_application.service.BizAgentApplicationPublishService;
import cn.com.yict.framemax.frame.service.FmxParamConfigService;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;

@Component
public class AgentApplicationMallSchedule {

    @Resource
    private BizAgentApplicationMallService bizAgentApplicationMallService;

    @Resource
    private BizAgentApplicationDialoguesRecordService bizAgentApplicationDialoguesRecordService;

    @Resource
    private BizAgentApplicationPublishService bizAgentApplicationPublishService;

    @Resource
    private FmxParamConfigService fmxParamConfigService;

    /**
     * 【用于更新DB的应用热度】
     * 定时规则：每分钟触发一次
     */
    @Scheduled(cron = "0 * * * * ?")
    public void updateAgentPopularity() throws Exception {
        // 查询应用市场表
        List<BizAgentApplicationMallEntity> mallEntities = bizAgentApplicationMallService.getList();
        // 获取权重
        Double w1 = Double.parseDouble(fmxParamConfigService.getParam("mall.collect.weight"));
        Double w2 = Double.parseDouble(fmxParamConfigService.getParam("mall.click.weight"));
        Double w3 = Double.parseDouble(fmxParamConfigService.getParam("mall.dialog.weight"));
        Double w4 = Double.parseDouble(fmxParamConfigService.getParam("mall.time.weight"));

        for(BizAgentApplicationMallEntity mallEntity : mallEntities){
            // 获取agentId
            BizAgentApplicationPublishEntity publishEntity = bizAgentApplicationPublishService.get(mallEntity.getAgentPublishId());

            if(publishEntity != null && publishEntity.getAgentId() != null){    // 如果有对话记录
                // 查询对话表，获取聊天次数和最后对话的时间
                BizAgentApplicationDialoguesRecordEntity recordEntity = new BizAgentApplicationDialoguesRecordEntity();
                recordEntity.setAgentId(publishEntity.getAgentId());
                List<BizAgentApplicationDialoguesRecordEntity> recordEntities = bizAgentApplicationDialoguesRecordService.findByExample(recordEntity);
                Double popularity;
                // 聊天次数
                int dialogNumber;
                // 时间衰减因子
                Double timeDecay;
                if(!recordEntities.isEmpty()){
                    // 更新聊天次数
                    dialogNumber = recordEntities.size();
                    // 当前时间戳
                    LocalDate today = LocalDate.now();
                    // 获取今天0:00的时间戳
                    long timestamp = today.atStartOfDay(ZoneOffset.UTC).toEpochSecond() * 1000;
                    // 时间衰减因子
                    timeDecay = w4 / Math.abs((recordEntities.get(0).getTimestamp() - timestamp)) / 1000;
                    BigDecimal round = new BigDecimal(timeDecay).round(new MathContext(3, RoundingMode.HALF_UP));
                    String string = round.toString();
                    timeDecay = Double.parseDouble(string.substring(0,4));
                    // 计算热度值
                    popularity = w1 * mallEntity.getCollectNumber() + w2 * mallEntity.getClickNumber() + w3 * ((Math.log(dialogNumber))/timeDecay);
                }else {
                    // 计算热度值
                    popularity = w1 * mallEntity.getCollectNumber() + w2 * mallEntity.getClickNumber();
                }
                // 更新热度值
                mallEntity.setPopularity(popularity);
                bizAgentApplicationMallService.update(mallEntity);
            }
        }
    }
}
