package cn.com.poc.agent_application.service.impl;

import cn.com.poc.agent_application.query.MallAgentApplicationQueryCondition;
import cn.com.poc.agent_application.query.MallAgentApplicationQueryItem;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.agent_application.service.BizAgentApplicationMallService;
import cn.com.poc.agent_application.model.BizAgentApplicationMallModel;
import cn.com.poc.agent_application.entity.BizAgentApplicationMallEntity;
import cn.com.poc.agent_application.convert.BizAgentApplicationMallConvert;
import cn.com.poc.agent_application.repository.BizAgentApplicationMallRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizAgentApplicationMallServiceImpl extends BaseServiceImpl
        implements BizAgentApplicationMallService {

    @Resource
    private BizAgentApplicationMallRepository repository;

    public BizAgentApplicationMallEntity get(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizAgentApplicationMallModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizAgentApplicationMallConvert.modelToEntity(model);
    }

    @Override
    public BizAgentApplicationMallEntity getByAgentPublishId(Integer agentPublishId) throws Exception {
        BizAgentApplicationMallModel model = new BizAgentApplicationMallModel();
        model.setIsDeleted("N");
        model.setAgentPublishId(agentPublishId);
        List<BizAgentApplicationMallModel> models = this.repository.findByExample(model);
        if (CollectionUtils.isNotEmpty(models)) {
            return BizAgentApplicationMallConvert.modelToEntity(models.get(0));
        }
        return null;
    }

    public List<BizAgentApplicationMallEntity> findByExample(BizAgentApplicationMallEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizAgentApplicationMallEntity> result = new ArrayList<BizAgentApplicationMallEntity>();
        BizAgentApplicationMallModel model = new BizAgentApplicationMallModel();
        if (example != null) {
            model = BizAgentApplicationMallConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizAgentApplicationMallModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAgentApplicationMallConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<BizAgentApplicationMallEntity> findByExample(PagingInfo pagingInfo) throws Exception {
        List<BizAgentApplicationMallEntity> result = new ArrayList<BizAgentApplicationMallEntity>();
        BizAgentApplicationMallModel model = new BizAgentApplicationMallModel();
        model.setIsDeleted("N");
        List<BizAgentApplicationMallModel> models = this.repository.findByExample(model, "id desc", pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAgentApplicationMallConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAgentApplicationMallEntity save(BizAgentApplicationMallEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizAgentApplicationMallModel model = BizAgentApplicationMallConvert.entityToModel(entity);
        BizAgentApplicationMallModel saveModel = this.repository.save(model);
        return BizAgentApplicationMallConvert.modelToEntity(saveModel);
    }

    public BizAgentApplicationMallEntity update(BizAgentApplicationMallEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizAgentApplicationMallModel model = this.repository.get(entity.getId());

        if (entity.getAgentPublishId() != null) {
            model.setAgentPublishId(entity.getAgentPublishId());
        }
        if (entity.getAgentType() != null) {
            model.setAgentType(entity.getAgentType());
        }
        if (entity.getCollectNumber() != null) {
            model.setCollectNumber(entity.getCollectNumber());
        }
        if (entity.getClickNumber() != null) {
            model.setClickNumber(entity.getClickNumber());
        }
        if (entity.getIsCopy() != null) {
            model.setIsCopy(entity.getIsCopy());
        }
        if (entity.getIsSale() != null) {
            model.setIsSale(entity.getIsSale());
        }
        if (entity.getCategoryId() != null) {
            model.setCategoryId(entity.getCategoryId());
        }
        if (entity.getPopularity() != null) {
            model.setPopularity(entity.getPopularity());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        BizAgentApplicationMallModel saveModel = this.repository.save(model);
        return BizAgentApplicationMallConvert.modelToEntity(saveModel);
    }

    @Override
    public void deletedByAgentPublishId(Integer agentPublishId) throws Exception {
        Assert.notNull(agentPublishId);
        BizAgentApplicationMallModel model = new BizAgentApplicationMallModel();
        model.setAgentPublishId(agentPublishId);
        List<BizAgentApplicationMallModel> models = this.repository.findByExample(model);
        if (!models.isEmpty()) {
            BizAgentApplicationMallModel mallModel = models.get(0);
            if ("N".equals(mallModel.getIsDeleted())) {
                mallModel.setIsDeleted("Y");
                this.repository.save(mallModel);
            }
        }
    }

    public void deletedById(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizAgentApplicationMallModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

    public List<BizAgentApplicationMallEntity> getList() throws Exception {
        List<BizAgentApplicationMallEntity> result = new ArrayList<BizAgentApplicationMallEntity>();
        List<BizAgentApplicationMallModel> models = this.repository.getAll();
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAgentApplicationMallConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<MallAgentApplicationQueryItem> mallAgentApplicationQuery(MallAgentApplicationQueryCondition condition, PagingInfo pagingInfo) {
        return this.sqlDao.query(condition, MallAgentApplicationQueryItem.class, pagingInfo);
    }
}