package cn.com.poc.common.annotation;

import org.springframework.stereotype.Component;

import java.lang.annotation.*;

/**
 * 限流
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Component
@Documented
public @interface RedisLimit {


    /**
     * 限流key
     */
    String key();


    /**
     * 限流数量 [单位时间内次数]
     */
    int count();

    /**
     * 限流时间 默认60秒
     */
    long timeout() default 60;

    /**
     * 限流时间单位 [默认秒]
     */
    LimitTimeUnit timeUnit() default LimitTimeUnit.SECONDS;

    /**
     * 是否针对当前用户
     *
     * @return
     */
    boolean currentUser() default false;

    /**
     * 异常信息
     */
    String exceptionInfo() default "";


    enum LimitTimeUnit {
        /**
         * 秒
         */
        SECONDS,

        /**
         * 分钟
         */
        MINUTES,
        /**
         * 小时
         */
        HOURS,
        /**
         * 天
         */
        DAYS,

        /**
         * 当日
         */
        DAY_OF_MONTH,

        /**
         * 当月
         */
        MONTH_OF_YEAR;

        LimitTimeUnit(){}
    }

}
